<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<!--
Mozile Documentation XSL: XML to XHTML

Revised: 2005-06-29
-->
	<xsl:output method="html" indent="yes"/>
	
	<!-- Tweak this parameter to get <html> or <div> tags, and all other appropriate changes -->
	<xsl:param name="page" select="true"/>	
	<xsl:param name="extension" select="'xml'"/>

	<xsl:template match="/">
		<xsl:choose>
			<xsl:when test="$page='false'">
				<div id="docs">
					<xsl:apply-templates />
				</div>
			</xsl:when>
			<xsl:otherwise>
				<html>
					<head>
						<title><xsl:value-of select="//title" /></title>
						<link rel="stylesheet" type="text/css" href="mozileDocs.css"/>
					</head>
					<body>
						<xsl:apply-templates />
					</body>
				</html>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template match="topmatter">
		<xsl:choose>
			<xsl:when test="$page='false'"></xsl:when>
			<xsl:otherwise>
				<p class="latest">View the latest version of these documents: <a href="http://mozile.mozdev.org/0.7/docs/index.html">http://mozile.mozdev.org/0.7/docs/index.html</a></p>
			</xsl:otherwise>
		</xsl:choose>
		
		<p class="intro">Welcome to Mozile, the WYSIWYG XHTML editor for Mozilla! This document is supposed to be a design specification for the Mozile 0.7 series of releases, describing the function of the Mozile Core. However, <b>it is far from being complete</b> at this point in time, and much of what it does contain <b>does not apply</b> to the Mozile 0.7 series. It is a work in progress, and we welcome suggestions and contributions.</p>
	
		<!-- Document List -->
		<div>
			<h1><a name="Documents">Documents</a></h1>
			<ol>
				<li><a href="index.{$extension}">Mozile Documentation</a> - A General Introduction to Mozile</li>
				<li><a href="mozileDevelopment.{$extension}">Mozile Development</a> - Notes on the Development of Mozile</li>
				<ol>
					<li><a href="JavaScript.{$extension}">JavaScript</a> - JavaScript resources</li>
					<li><a href="DOM.{$extension}">DOM</a> - Document Object Model resources</li>
					<li><a href="XUL.{$extension}">XUL</a> - Extensible User-Interface Language resources</li>
					<li><a href="XBL.{$extension}">XBL</a> - Extensible Binding Language resources</li>
					<li><a href="JSDoc.{$extension}">JSDoc</a> - JSDoc documentation resources</li>
					<li><a href="JSUnit.{$extension}">JSUnit</a> - JSUnit testing framework resources</li>
				</ol>
				<li><a href="mozileDesign.{$extension}">Mozile Design</a> - An explanation of the design of Mozile</li>
				<ol>
					<li><a href="mozileUsage.{$extension}">Mozile Usage</a> - A description of how Mozile is used (behaviour specification)</li>
					<li><a href="mozileCore.{$extension}">Mozile Core</a> - A description of the Mozile Core code</li>
					<li><a href="mozileModules.{$extension}">Mozile Modules</a> - A description of the Mozile Modules</li>
					<li><a href="mozileServerSide.{$extension}">Mozile Server-Side</a> - A description of the Mozile Server-Side code</li>
					<li><a href="mozileExtension.{$extension}">Mozile Extension</a> - A description of the Mozile Extension code</li>
					<li><a href="mozileEditorObject.{$extension}">mozileEditor Object</a> - A description of the mozileEditor object</li>
					<li><a href="mozileContainernObject.{$extension}">mozileContainer Object</a> - A description of the mozileContainer object</li>
					<li><a href="mozileExtensionObject.{$extension}">mozileExtension Object</a> - A description of the mozileExtension object</li>
				</ol>
			</ol>
		</div>
		
		<!-- Table of Contents -->
		<div>
			<h1><a name="Contents">Contents</a></h1>
			<ol>
				<xsl:apply-templates select="//document/section" mode="toc"/>
			</ol>
		</div>
	</xsl:template>
	
	<xsl:template match="section" mode="toc">
		<li>
			<a>
				<xsl:attribute name="href">
					<xsl:text>#</xsl:text>
					<xsl:value-of select="@name"/>
				</xsl:attribute>
				<xsl:value-of select="@name"/>
			</a>
			<xsl:if test="section">
				<ol>
					<xsl:apply-templates select="section" mode="toc"/>
				</ol>
			</xsl:if>
		</li>
	</xsl:template>

	<xsl:template match="section">
		<div>
			<h1>
				<a>
					<xsl:attribute name="name">
						<xsl:value-of select="@name"/>
					</xsl:attribute>
					<xsl:value-of select="@name"/>
				</a>
			</h1>
			<xsl:apply-templates/>
		</div>
	</xsl:template>

	<xsl:template match="section/section">
		<div>
			<h2>
				<a>
					<xsl:attribute name="name">
						<xsl:value-of select="@name"/>
					</xsl:attribute>
					<xsl:value-of select="@name"/>
				</a>
			</h2>
			<xsl:apply-templates/>
		</div>
	</xsl:template>
	
	<xsl:template match="title">
	</xsl:template>
	
	<xsl:template match="heading">
	</xsl:template>
	
	<xsl:template match="latest">
		<xsl:choose>
			<xsl:when test="$page='false'"></xsl:when>
			<xsl:otherwise>
				<p class="latest"><xsl:apply-templates/></p>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="introduction">
		<p class="intro"><xsl:apply-templates/></p>
	</xsl:template>
	
	<xsl:template match="note">
		<p class="note"><xsl:apply-templates/></p>
	</xsl:template>
	
	<xsl:template match="p">
		<p><xsl:apply-templates/></p>
	</xsl:template>
	
	<xsl:template match="code">
		<code><xsl:apply-templates/></code>
	</xsl:template>
	
	<xsl:template match="list">
		<xsl:if test="@name">
			<b>
				<xsl:value-of select="@name"/>
			</b>
		</xsl:if>
		<xsl:choose>
			<xsl:when test="@type='ordered'">
				<ol><xsl:apply-templates/></ol>	
			</xsl:when>
			<xsl:otherwise>
				<ul><xsl:apply-templates/></ul>	
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="item">
		<li>
			<xsl:if test="@name">
				<em>
					<xsl:value-of select="@name"/>
				</em>
			</xsl:if>
			<xsl:text> </xsl:text>
			<xsl:apply-templates/>
		</li>
	</xsl:template>
	
	<xsl:template match="option">
		<div class="option"><xsl:if test="@name"><p class="heading"><xsl:value-of select="@name"/></p></xsl:if> <xsl:apply-templates/></div>
	</xsl:template>

	<xsl:template match="finePrint">
		<div class="finePrint"><xsl:apply-templates/></div>
	</xsl:template>
	
	<xsl:template match="em">
		<em><xsl:apply-templates/></em>
	</xsl:template>
	
	<xsl:template match="p">
		<p><xsl:apply-templates/></p>
	</xsl:template>
	
	<xsl:template match="date">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="a">
		<a>
			<xsl:attribute name="href">
					<!-- This ugliness converts Links so that they will point to CVS . It is applied when the $page parameter is set to False -->
				<xsl:choose>
				<xsl:when test="$page='false' and (contains(@href,'://')=false) and (starts-with(@href,'#')=false)">
					<xsl:choose>
						<xsl:when test="starts-with(@href,'../../skin/')">http://www.mozdev.org/source/browse/mozile/source/extension/mozile-0.6/skin/classic/<xsl:value-of select="substring-after(@href,'../../skin/')"/></xsl:when>
						<xsl:when test="starts-with(@href,'../../locale/')">http://www.mozdev.org/source/browse/mozile/source/extension/mozile-0.6/locale/en-US/<xsl:value-of select="substring-after(@href,'../../locale/')"/></xsl:when>
						<xsl:otherwise>http://www.mozdev.org/source/browse/mozile/source/extension/mozile-0.6/content/doc/<xsl:value-of select="@href"/></xsl:otherwise>
					</xsl:choose>
				</xsl:when>
					<xsl:otherwise><xsl:value-of select="@href"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:attribute name="target">
				<xsl:value-of select="@target"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</a>
	</xsl:template>
	
	<xsl:template match="image">
		<img>
			<xsl:attribute name="src">
					<!-- This ugliness converts Links so that they will point to CVS . It is applied when the $page parameter is set to False -->
				<xsl:choose>
					<xsl:when test="$page='false' and (contains(@source,'://')=false) and (starts-with(@source,'#')=false)">
						<xsl:choose>
							<xsl:when test="starts-with(@source,'../../skin/')">http://www.mozdev.org/source/browse/mozile/source/extension/mozile-0.6/skin/classic/<xsl:value-of select="substring-after(@source,'../../skin/')"/></xsl:when>
							<xsl:when test="starts-with(@source,'../../locale/')">http://www.mozdev.org/source/browse/mozile/source/extension/mozile-0.6/locale/en-US/<xsl:value-of select="substring-after(@source,'../../locale/')"/></xsl:when>
							<xsl:otherwise>http://www.mozdev.org/source/browse/mozile/source/extension/mozile-0.6/content/doc/<xsl:value-of select="@source"/></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise><xsl:value-of select="@source"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</img>
	</xsl:template>

</xsl:stylesheet>