/** Insert and Remove Script tests
 * Test the insertScript, removeScript, and removeAllScripts functions.
 **/

mozile = new Mozile("root='../../', debugLevel=-1, warnBeforeUnload=false");
var i;

// Check to se that the mozile object instance exists
function testMozileExists() {
	assertNotNull("The mozile object should exist.", mozile);
	assertNotUndefined("The mozile object should be defined.", mozile);
}


// Compare how many links there are in this page before and after injectScript is called.
function testLoadLink() {
	var links1 = document.getElementsByTagName("link").length;
	mozile.loadLink("dummy.css","Mozile-Test-dummy.css");
	var links2 = document.getElementsByTagName("link").length;
	assertEquals("There should be one more link now.", links1+1, links2);

	var links = document.getElementsByTagName("link");
	var dummies = 0;
	for(i=0;i<links.length;i++) {
		if(links[i].getAttribute("href") == "dummy.css") dummies++;
	}
	assertEquals("There should be one dummy link element.",1,dummies);
}

// Compare how many links there are in this page before and after removeScript is called.
function testUnloadLink() {
	var links1 = document.getElementsByTagName("link").length;
	mozile.unloadLink("Mozile-Test-dummy.css");
	var links2 = document.getElementsByTagName("link").length;
	assertEquals("There should be one fewer link now.", links1-1, links2);

	var links = document.getElementsByTagName("link");
	var dummies = 0;
	for(i=0;i<links.length;i++) {
		if(links[i].getAttribute("href") == "dummies.js") dummies++;
	}
	assertEquals("There should be no dummy link elements.",0,dummies);
}

