// create the Mozile instance, absolutely no debugging messages
var mozile, scripts, j, i;


// Test the constructor
function testConstructor() {
	var root = "../../";
	var mode = "HTML";
	var namespace = "namespace";
	var debugLevel = "-1";
	mozile = new Mozile("root='"+root+"', mode="+mode+", namespace='"+namespace+"', debugLevel="+debugLevel+", warnBeforeUnload=false");
	assertNotNull("The mozile object should exist", mozile);
	assertNotUndefined("The mozile object should be defined.", mozile);
	assertEquals("The root should be "+root, root, mozile.root);
	assertEquals("The mode should be "+mode, mode, mozile.mode);
	assertEquals("The namespace should be "+namespace, namespace, mozile.namespace);
	assertEquals("The debugLevel should be "+debugLevel, debugLevel, mozile.debugLevel);
}




// Test the simplest module configuration string
function testBasicParsing() {
	var configString = "DummyModule garbage text";
	var arr = mozile.parseConfig(configString);
	assertNotNull("The configuration array should exist", arr);
	assertNotUndefined("The configuration array should be defined.", arr);
	assertNotNull("The configString key should exist", arr['configString']);
	assertNotUndefined("The configString key should be defined", arr['configString']);
	assertEquals("The configString should be returned", configString, arr['configString']);
	assertNotNull("The name key should exist", arr['name']);
	assertNotUndefined("The name key should be defined", arr['name']);
	assertEquals("The name should be DummyModule","DummyModule",arr['name']);

	assertEquals("The result of testFunction should be '0'", 0, mozile.testFunction());
}

// Test a module configuration string with lots of options
function testAdvancedParsing() {
	var configString = "DummyModule: minVersion=1.0.2, maxVersion=1.1.2, notVersion=1.1.0, notVersion=1.0.6, requireVersion=1.0.7, remoteVersion=1.0.7, forceRemote=false, remotePath='/path/to/module/' ";
	var arr = mozile.parseConfig(configString);
	assertNotNull("The configuration array should exist", arr);
	assertNotUndefined("The configuration array should be defined.", arr);
	
	var pairs = new Array();
	pairs['configString']=configString;
	pairs['name']="DummyModule";
	pairs['minVersion']="1.0.2";
	pairs['maxVersion']="1.1.2";
	pairs['requireVersion']="1.0.7";
	pairs['remoteVersion']="1.0.7";
	pairs['forceRemote']='false';
	pairs['remotePath']="/path/to/module/";
	
	for(key in pairs) {
		assertNotNull("The "+key+" should exist", arr[key]);
		assertNotUndefined("The "+key+" should be defined", arr[key]);
		assertEquals("The "+key+" should be "+pairs[key], pairs[key],arr[key]);
	}
	
	// TODO: test notVersion

}

// Test a module configuration string that is a mess, but still valid
function testUglyParsing() {
	var configString = "  DummyModule garbage:junk,, minVersion=1.0.2, maxVersion=1.1.2,  notVersion=1.1.0,trash notVersion=1.0.6, requireVersion=1.0.7, remoteVersion=1.0.7, forceRemote=false, remotePath='/path/to/another module/' extra_stuff =ww";
	var arr = mozile.parseConfig(configString);
	assertNotNull("The configuration array should exist", arr);
	assertNotUndefined("The configuration array should be defined", arr);
	
	var pairs = new Array();
	pairs['configString']=configString;
	pairs['name']="DummyModule";
	pairs['minVersion']="1.0.2";
	pairs['maxVersion']="1.1.2";
	pairs['requireVersion']="1.0.7";
	pairs['remoteVersion']="1.0.7";
	pairs['forceRemote']='false';
	pairs['remotePath']="/path/to/another module/";
	
	for(key in pairs) {
		assertNotNull("The "+key+" should exist", arr[key]);
		assertNotUndefined("The "+key+" should be defined", arr[key]);
		assertEquals("The "+key+" should be "+pairs[key], pairs[key],arr[key]);
	}
	
	// TODO: test notVersion

}



function testRegistration() {
	var testModule = "TestModule";
	var otherModule = "otherModule";
	var version = "1.2.3";
	
	var result = mozile.registerModule(testModule, version);	
	assertTrue("The registerModule function should return true", result);
	assertNotUndefined("There should be now be a "+ testModule +" entry in the moduleList", mozile.moduleList[testModule]);
	assertEquals("The "+ testModule +" entry should have a value "+version, version, mozile.moduleList[testModule]);
	
	assertTrue("Now the "+ testModule +" should be loaded", mozile.moduleIsLoaded(testModule));
	assertFalse("But the "+ otherModule +" should not be loaded", mozile.moduleIsLoaded(otherModule));
	
	result = mozile.unregisterModule(testModule);
	assertTrue("The unregisterModule function should succeed with "+ testModule, result);
	assertFalse("Now the "+ testModule +" should not be loaded", mozile.moduleIsLoaded(testModule));

	result = mozile.unregisterModule(otherModule);
	assertFalse("The unregisterModule function should fail with "+ otherModule, result);

}


function testCheckRequirements() {

	var requirements = "requireVersion=1.2.3";
	assertTrue("The requirements for 1.2.3 should be met", mozile.checkRequirements("1.2.3",requirements));
	assertFalse("The requirements for 1.2.4 should not be met", mozile.checkRequirements("1.2.4",requirements));

	requirements = "minVersion=1.0.0, maxVersion=1.3.4, notVersion=1.2.1, notVersion=1.2.3";
	var checks = new Array();
	checks["0"]=false;
	checks[""]=false;
	checks["cats"]=false;
	checks["0.9.9"]=false;
	checks["0.9.99"]=false;
	checks["0.99.99"]=false;
	checks["1.0.0"]=true;
	checks["1.1.0"]=true;
	checks["1.1.1"]=true;
	checks["1.1.100"]=true;
	checks["1.2.0"]=true;
	checks["1.2.1"]=false;
	checks["1.2.2"]=true;
	checks["1.2.3"]=false;
	checks["1.3.0"]=true;
	checks["1.3.4"]=true;
	checks["1.3.5"]=false;
	checks["1.33.5"]=false;
	checks["1.4.5"]=false;
	checks["2.0.0"]=false;
	checks["200.0.0"]=false;
	
	for(key in checks) {
		if(checks[key]) {
			assertTrue("The requirements for "+key+" should be met", mozile.checkRequirements(key,requirements));
		}
		else {
			assertFalse("The requirements for "+key+" should not be met", mozile.checkRequirements(key,requirements));
		}
	
	}
}



function testLoadModule1() {
	var configString="TestModule1";
	var name="TestModule1";
	var id = "Mozile-TestModule1-TestModule1.js";
	
	// Try loading the module. This should succeed.
	var result = mozile.loadModule(configString);
	assertTrue("The first attempt to load the module should return true", result);
	
	// Make sure that the new script tag exists
	var tag = document.getElementById(id);
	assertNotNull("There should be a script tag with id "+id, tag);
	assertNotUndefined("There should be a script tag with id "+id, tag);
	
	// Make sure only one such element exists	
	scripts = document.getElementsByTagName("script");
	j=0;
	for(i=0; i < scripts.length; i++) {
		if(scripts[i].id == id) j++;
	}
	assertEquals("There should be only one script tag with id "+id,1,j);
	
	// Make sure that it has been added once to the moduleList
	assertNotNull("The moduleList should contain a "+ name +" entry", mozile.moduleList[name]);
	assertNotUndefined("The moduleList should contain a "+ name +" entry", mozile.moduleList[name]);
	assertEquals("The version of TestModule1 should be 'unknown version'","unknown version", mozile.moduleList['TestModule1']);
	

	// Try loading the module a second time. This should fail.
	result = mozile.loadModule(configString);
	assertFalse("The second attempt to load the module should return false", result);
	
	// Make sure there is still only on script element with the given id
	scripts = document.getElementsByTagName("script");
	j=0;
	for(i=0; i < scripts.length; i++) {
		if(scripts[i].id == id) j++;
	}
	assertEquals("There should be only one script tag with id "+id,1,j);
	
	// Module will not be loaded yet. See next script tag.
}

