

// The modules should now be loaded, so make sure that they are.
function testLoaded1() {
	assertNotNull("The testModule1Loaded variable should exist", testModule1Loaded);
	assertNotUndefined("The testModule1Loaded variable should be defined", testModule1Loaded);
	assertEquals("The testModule1Loaded variable should be defined as 'Apes'", "Apes", testModule1Loaded);
	assertEquals("The version of TestModule1 should be set","1.0.0", mozile.moduleList['TestModule1']);
	assertEquals("The result of testFunction should be '1'", 1, mozile.testFunction());
}

function testLoadModule2() {
	var configString="TestModule2";
	var name="TestModule2";
	var id = "Mozile-TestModule1-TestModule1.js";
	mozile.loadModule(configString);
	
	// Make sure that the new script tag exists
	var tag = document.getElementById(id);
	assertNotNull("There should be a script tag with id "+id, tag);
	assertNotUndefined("There should be a script tag with id "+id, tag);
	
	// Make sure only one such element exists	
	var scripts = document.getElementsByTagName("script");
	var j=0;
	for(i=0; i < scripts.length; i++) {
		if(scripts[i].id == id) j++;
	}
	assertEquals("There should be only one script tag with id "+id, 1 ,j);
	
	assertNotNull("The moduleList should contain a "+ name +" entry", mozile.moduleList[name]);
	assertNotUndefined("The moduleList should contain a "+ name +" entry", mozile.moduleList[name]);
	assertEquals("The version of TestModule2 should be 'unknown version'","unknown version", mozile.moduleList['TestModule2']);
	
	// Module will not be loaded yet. See next script tag.
}

