/** Insert and Remove Script tests
 * Test the insertScript, removeScript, and removeAllScripts functions.
 **/

mozile = new Mozile("root='../../', debugLevel=-1, warnBeforeUnload=false");

// Check to se that the mozile object instance exists
function testMozileExists() {
	assertNotNull("The mozile object should exist.", mozile);
	assertNotUndefined("The mozile object should be defined.", mozile);
}


// Compare how many scripts there are in this page before and after injectScript is called.
function testLoadScript() {
	var scripts1 = document.getElementsByTagName("script").length;
	mozile.loadScript("dummy.js","Mozile-Test-dummy.js");
	var scripts2 = document.getElementsByTagName("script").length;
	assertEquals("There should be one more script now.", scripts1+1, scripts2);

	var scripts = document.getElementsByTagName("script");
	var dummies = 0;
	for(i=0;i<scripts.length;i++) {
		if(scripts[i].getAttribute("src") == "dummy.js") dummies++;
	}
	assertEquals("There should be one dummy script element.",1,dummies);
}

// Compare how many scripts there are in this page before and after removeScript is called.
function testUnloadScript() {
	var scripts1 = document.getElementsByTagName("script").length;
	mozile.unloadScript("Mozile-Test-dummy.js");
	var scripts2 = document.getElementsByTagName("script").length;
	assertEquals("There should be one script fewer now.", scripts1-1, scripts2);

	var scripts = document.getElementsByTagName("script");
	var dummies = 0;
	for(i=0;i<scripts.length;i++) {
		if(scripts[i].getAttribute("src") == "dummies.js") dummies++;
	}
	assertEquals("There should be no dummy script elements.",0,dummies);
}