/** Toolbar tests
 * Test the createToolbar function.
 **/

mozile = new Mozile("root='../../', debugLevel=-1, warnBeforeUnload=false");

// Check to se that the mozile object instance exists
function testMozileExists() {
	assertNotNull("The mozile object should exist.", mozile);
	assertNotUndefined("The mozile object should be defined.", mozile);
}


function testCreateToolbar() {
	mozile.createToolbar();
	
	var basicSheet = document.getElementById("Mozile-Core-widgets.css");
	assertNotNull("The basicSheet should exist.", basicSheet);
	assertNotUndefined("The basicSheet should be defined.", basicSheet);
	
	var style = document.getElementById("Mozile-Core-StyleSheet");
	assertNotNull("The style element should exist.", style);
	assertNotUndefined("The style element should be defined.", style);

	var sheets = document.styleSheets;
	var sheet;
	for(var i=0; i < sheets.length; i++) {
		if(sheets.item(i).ownerNode == style) {
			sheet = sheets.item(i);
			break;
		}
	}
	assertNotUndefined("The sheet should be defined.", sheet);
	
	assertNotNull("The mozile.styleSheet should be defined.", mozile.styleSheet);
	assertNotUndefined("The mozile.styleSheet should be defined.", mozile.styleSheet);

	assertEquals("There should only be one rule", 1, mozile.styleSheet.cssRules.length);
	
	var rule = mozile.styleSheet.cssRules[0];
	var text;
	if(document.documentElement.nodeName.toLowerCase()=="html") {
		text = "body { -moz-binding: url(" + mozile.root +"core/widgets.xbl#toolbar); }"
	}
	else {
		text = "moziletoolbar { -moz-binding: url(" + mozile.root +"core/widgets.xbl#toolbar); }"
	}
	assertEquals("The rule's text should be "+ text, text, rule.cssText);

}
