/** Mozile Interface Test Script
 * @fileoverview This file contains JSUnit test functions for testing the MozileInterface class. 
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.2
 */

/* Known Issues
testShowHideExternal crashes the browser when testing XUL pages.
*/

var name = "Interface";
var id = "target";
var width = "300px";
var height = "200px";
var configString = name+": width="+width+", height="+height;

/** Test - Constructor
 * Make sure that the MozileInterface constructor is working. Use the default namespace.
 */
function testConstructor() {
	var element = document.getElementById(id);
	var component = new MozileInterface(element, configString);
	checkComponentBasics(component);
}


/** Test - Options
 * Test getting and setting options.
 */
function testOptions() {
	var element = document.getElementById(id);
	var configString = "DummyModule garbage text";
	var component = new MozileInterface(element, configString);
	checkOptions(component);
}


/** Test - Show and Hide Element
 * Test showing and hiding the interface, which means inserting and removing it.
 */
function testShowHideElement() {
	var element = document.getElementById(id);
	var category = element.localName;
	var component = new MozileInterface(element, configString);
	
	var count1 = document.getElementsByTagName(category).length;
	assertEquals("There should be one element with the matching id", 1, countElements(category, id));
	
	try {
		component.hide();
		var count2 = document.getElementsByTagName(category).length;
		assertEquals("There should be one fewer element now.", count2, count1-1);
		assertEquals("There should be no elements with the matching id", 0, countElements(category, id));
		
		component.hide();
		var count3 = document.getElementsByTagName(category).length;
		assertEquals("There should be the same number of elements now.", count3, count2);
		assertEquals("There should be no elements with the matching id", 0, countElements(category, id));
		
		component.show()
		var count4 = document.getElementsByTagName(category).length;
		assertEquals("There should be one more element now.", count4, count3+1);
		assertEquals("There should be one element with the matching id", 1, countElements(category, id));
		
	} 
	catch(e) {
		alert("Error showing and hiding: "+e);
	} 
	finally {
			// Make sure to show the element again, or else the other tests will fail.
		component.show();
	}
}


/** Test - Show and Hide External
 * Test showing and hiding the interface. Involes loading an external file.
 */
function testShowHideExternal() {
		// Bad crash for XUL test - avoid it!!
	if(String(document.location).search("testpage\.xul") > 0)	return;

	
	var url = "../core/about.xml"; // path from jsunit directory
	var id = "MozileAboutInterface";
	var category = "vbox";
	var component = new MozileInterface(url, configString);
	component.show();
	
	var count1 = document.getElementsByTagName(category).length;
	assertEquals("There should be one element with the matching id", 1, countElements(category, id));
	
	try {
		component.hide();
		var count2 = document.getElementsByTagName(category).length;
		assertEquals("There should be one fewer element now.", count2, count1-1);
		assertEquals("There should be no elements with the matching id", 0, countElements(category, id));
		
		component.hide();
		var count3 = document.getElementsByTagName(category).length;
		assertEquals("There should be the same number of elements now.", count3, count2);
		assertEquals("There should be no elements with the matching id", 0, countElements(category, id));
		
		component.show()
		var count4 = document.getElementsByTagName(category).length;
		assertEquals("There should be one more element now.", count4, count3+1);
		assertEquals("There should be one element with the matching id", 1, countElements(category, id));
		
	} 
	catch(e) {
		alert("Error showing and hiding: "+e);
	} 
	finally {
			// Make sure to show the element again, or else the other tests will fail.
		component.show();
	}
}





/** Test - Check Component Basics
 * Basic tests to ensure that the component exists and simple methods are working.
 */
function checkComponentBasics(component) {
	assertNotNull("component should not be null", component);
	assertNotUndefined("component should not be undefined", component);
	assertEquals("component should be an object", typeof(new Object()), typeof(component));
	
	assertEquals("getName() should return the name", name, component.getName());
	assertNotNull("The configString key should exist", component.getConfigString());
	assertNotUndefined("The configString key should be defined", component.getConfigString());

	assertNotNull("getOptions() should not be null", component.getOptions());
	assertNotUndefined("getOptions() should be defined.", component.getOptions());
	assertEquals("getOptions() should return an object.", typeof(new Object), typeof(component.getOptions()));
	
	assertNotNull("getElement() should not be null", component.getElement());
	assertNotUndefined("getElement() should be defined.", component.getElement());
	assertEquals("getElement() should return an element.", 1, component.getElement().nodeType);
	
	assertNotNull("getParent() should not be null", component.getParent());
	assertNotUndefined("getParent() should be defined.", component.getParent());
	assertEquals("getParent() should return an element.", 1, component.getParent().nodeType);
}

