/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/license.html
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code was written by Max d'Ayala (www.dAyala.co.uk).
 *
 * The Initial Developer of the Original Code is Max d'Ayala
 * Portions created by the Initial Developer are Copyright (C) 2002-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	Max d'Ayala (www.dAyala.co.uk)
 *	Tobias Minich
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** HTTP POST
 * @fileoverview This module is used to save documents via HTTP POST. You must have a server which is configured to accept the POST data and take action. Examples for catching the POST data are provided in PHP and JSP format. The PHP examples include tests for handling saving errors.
 * <p>To configure Mozile to use HTTPPost for saving, add the following line to the "modules" array in your mozile.js configuration file: "HTTPPost". You can add more options, for example: "HTTPPost: url='http://somewhere.com/save.php', default=true".
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */
 
 /** 
 * Initialize the module.
 * @type Void
 */
mozile.getModule("HTTPPost").init = function() {
		// Copy this module to the mozile save list
	mozile.addSaveModule(mozile.getModule("HTTPPost"));
		// Set some options
	mozile.getModule("HTTPPost").setOption("label", "Save via HTTP POST");
	mozile.getModule("HTTPPost").setOption("showURL", true);
	
		// If the configuration of this modules does not give a url, set it to ""
	if(!mozile.getModule("HTTPPost").getOption("url")) {
		mozile.getModule("HTTPPost").setOption("url", "http://localhost");
	}
		// If the configuration of this modules says it's the default, then set it as the default.
	if(mozile.getModule("HTTPPost").getOption("default")) {
		mozile.setDefaultSaveModule(mozile.getSaveModule("HTTPPost"));
	}

	mozile.getModule("HTTPPost").getOption("location", "automatic"); // can be "automatic" or "never"
	mozile.getModule("HTTPPost").getOption("display", "automatic"); // can be "automatic" or "always" or "never"
}

mozile.getModule("HTTPPost").getInterface = function() {
	if(!this._interface) {
		this._interface = new MozileInterface(mozile.getModule("HTTPPost").getPath() +"savemsg.xml", "HTTPPostInterface: width=450px");
		this._interface.init = function() {
			var response = document.getElementById("HTTPPostResponseText");
			var statustext = document.getElementById("HTTPPostStatusText");
			while(statustext.childNodes.length) statustext.removeChild(statustext.firstChild);
			if(mozileXHR.responseText) response.value = mozileXHR.responseText;
			if(this.getOption("statustext")) statustext.appendChild(document.createTextNode(this.getOption("statustext")));
			else statustext.appendChild(document.createTextNode("Status Unknown"));
		}
	}
	return this._interface;
}


// Global XMLHTTPRequest object.
var mozileXHR = new XMLHttpRequest();


/** 
 * Save via HTTP POST.
 * @type Void
 */
mozile.getModule("HTTPPost").save = function() {
	var f = new Array();
	f["File"] = "HTTPPost/HTTPPost.js";
	f["Function"] = "save";
	
	var httpSavePath = mozile.getSaveOption("current", "url");
	if(mozile.getSaveOption("current", "content") == "editor" &&
			mozile.getCurrentEditor().id) {
			// check if another param exists, if yes, add with &
		if(httpSavePath.indexOf('?') != -1){
			httpSavePath = httpSavePath + "&MozileID=" + mozile.getCurrentEditor().id;	
		}else{ // 
			httpSavePath = httpSavePath + "?MozileID=" + mozile.getCurrentEditor().id;
		}
	}

	var contentType = "text/plain";
	if (mozile.getSaveOption("current", "contentType")) contentType = mozile.getSaveOption("current", "contentType");
	else if(mozile.getSaveOption("current", "content") == "document") contentType = document.contentType;
	
	const CR = '\x0D';
	const LF = '\x0A';
	var content = CR + LF + mozile.content() + CR + LF;
	
	this.getInterface().setOption("statustext", undefined);
	mozile.status(f,3,"Begining save to '"+ mozile.getSaveOption("current", "url") +"'", 0, "mozile.getModule('HTTPPost').getInterface().show()");

	try {
		mozileXHR.abort(); // make sure no other requests are running.
		mozileXHR.open("POST", httpSavePath, true, null, null);
		mozileXHR.setRequestHeader('Content-Type', contentType + "; " + document.characterSet);	

		// For Gecko versions after 1.7, content length shouldn't be supplied. It is added automatically for XUL files.
		//The length will include the two CR/LF pairs.
		//Refer to Mozilla docs: http://developer.mozilla.org/en/docs/XMLHttpRequest_changes_for_Gecko1.8
		if(mozile.getMozillaVersion().indexOf("1.7") > 0) mozileXHR.setRequestHeader('Content-Length', content.length);
		
		mozileXHR.setRequestHeader('Content-Location', mozile.getSaveOption("current", "url"));
		mozileXHR.onerror = this._onerror;
		mozileXHR.onreadystatechange = this._onchange;
		mozileXHR.onload = this._onload;
		mozileXHR.send(content);
		mozile.debug(f,1,"POST sent");
	}catch (e){
		mozile.debug(f,4,"Exception: "+e);
		mozile.status(f,3,"Save Failed! Permission denied to save to URL \"" + mozile.getSaveOption("current", "url") +"\"");
	}


}

/** 
 * Aborts any active request operation.
 * @type Void
 */
mozile.getModule("HTTPPost").abort = function() {
	var f = new Array();
	f["File"] = "HTTPPost/HTTPPost.js";
	f["Function"] = "abort";
	mozileXHR.abort();
	mozile.status(f,3,"Save aborted by user.");
}

/** 
 * Handler request errors.
 * @private
 * @type Void
 */
mozile.getModule("HTTPPost")._onerror = function() {
	var f = new Array();
	f["File"] = "HTTPPost/HTTPPost.js";
	f["Function"] = "onerror";
	mozile.status(f,3,"Save Failed! There was an error in the HTTP POST.");
}

/** 
 * Handler request changes.
 * @private
 * @type Void
 */
mozile.getModule("HTTPPost")._onchange = function() {
	var f = new Array();
	f["File"] = "HTTPPost/HTTPPost.js";
	f["Function"] = "onchange";
	
	var message = "Save via HTTP POST: ";
	switch ( mozileXHR.readyState ) {
	case 1 :
		mozile.status(f,3, message+"1. Initialising...", 10, "mozile.getModule('HTTPPost').getInterface().show()");
		break;
	case 2 :
		mozile.status(f,3, message+"2. Sending...", 50, "mozile.getModule('HTTPPost').getInterface().show()");
		break;
	case 3 :
		mozile.status(f,3, message+"3. Receiving acknowledgement...", 90, "mozile.getModule('HTTPPost').getInterface().show()");
		break;
	case 4 :
		// let onload handle this case.
		break;
	}
}

/** 
 * Handler request completion.
 * @private
 * @type Void
 */
mozile.getModule("HTTPPost")._onload = function() {
	var f = new Array();
	f["File"] = "HTTPPost/HTTPPost.js";
	f["Function"] = "onload";

		// Response Received. Try to parse message.
	if( mozileXHR.responseXML &&
			(mozileXHR.status == 200 || mozileXHR.status == 201 ) ) {
			// try to parse the response
		var root = mozileXHR.responseXML.getElementsByTagName("mozile")[0];
		if(root) {
			var status = root.getElementsByTagName("status")[0];
			var statustext = root.getElementsByTagName("statustext")[0];
			var location = root.getElementsByTagName("location")[0];
			var display = root.getElementsByTagName("display")[0];
			
			if(status && status.firstChild && status.firstChild.textContent && 
					statustext && statustext.firstChild && statustext.firstChild.textContent) {
				mozile.getModule("HTTPPost").getInterface().setOption("statustext", statustext.firstChild.textContent);
					// Success code = 1
				if(status.firstChild.textContent == "1") mozile.status(f,3,"Save Complete. "+ statustext.firstChild.textContent, 100, "mozile.getModule('HTTPPost').getInterface().show()");
					// Any other code means failure.
				else mozile.status(f,3,"Save Failed! Server error: "+ statustext.firstChild.textContent, 0, "mozile.getModule('HTTPPost').getInterface().show()");
				
					// If a location is provided, use it.
				if(mozile.getModule("HTTPPost").getOption("location")=="automatic" &&
						location && location.firstChild && location.firstChild.textContent) {
					if(location.getAttribute("replace") && 
							location.getAttribute("replace").toLowerCase() == "true") 
								document.location = location.firstChild.textContent;
					else window.open(location.firstChild.textContent);
				}
					// If "display" is requested, show the interface.
				if(mozile.getModule("HTTPPost").getOption("display")=="automatic" &&
						display && display.firstChild && display.firstChild.textContent=="yes") mozile.getModule("HTTPPost").getInterface().show();
			}
			else mozile.status(f,3, "Save Failed! Invalid server response.", 0, "mozile.getModule('HTTPPost').getInterface().show()");
		}
	}
		// Empty response. Assume success.
	else if (mozileXHR.status == 204) {
		mozile.status(f,3,"Save Complete.", 100, "mozile.getModule('HTTPPost').getInterface().show()");
	}
	else if (mozileXHR.status == 404) {
		mozile.status(f,3,"Save failed! Error 404 'File not found'.", 0, "mozile.getModule('HTTPPost').getInterface().show()");
		MozileHTTPPostInterface.setOption("statustext", "HTTP Response Code "+mozileXHR.status);
	}
		// Otherwise saved failed.
	else {
		mozile.status(f,3, "Save Failed! Unexpected server response.", 0, "mozile.getModule('HTTPPost').getInterface().show()");
		MozileHTTPPostInterface.setOption("statustext", "HTTP Response Code "+mozileXHR.status);
	}
	if(mozile.getModule("HTTPPost").getOption("display")=="always") mozile.getModule("HTTPPost").getInterface().show();
}

