/** Mozile InsertionPoint Test Script
 * @fileoverview This file contains JSUnit test functions for testing Mozile's InsertionPoint object.
 * 
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */


/**
 * 
 */
function testGetters() {
	var selection = window.getSelection();
	selection.removeAllRanges();
	assertNull("Without a selection the IP should be null.", selection.createInsertionPoint());
	
	resetSelection();
	var IP = window.getSelection().createInsertionPoint();
	assertNotNull("The IP should not be null.", IP);
	assertNotUndefined("The IP should not be undefined.", IP);
	
	var node = document.getElementById("target2").firstChild;
	assertEquals("getNode should be 'target2'.", node, IP.getNode());
	assertEquals("getOffset should be '0'.", 0, IP.getOffset());
}

/**
 *
 */
function testSelect() {
	var node = document.getElementById("target2").firstChild;
	var offset = 5;
	var IP = new InsertionPoint(node, offset);
	
	assertNotNull("The IP should not be null.", IP);
	assertNotUndefined("The IP should not be undefined.", IP);
	assertEquals("getNode should be 'target2'.", node, IP.getNode());
	assertEquals("getOffset should be "+offset, offset, IP.getOffset());
	
	var selection = window.getSelection();
	selection.removeAllRanges();
	assertNull("anchorNode should be null", selection.anchorNode);
	assertEquals("anchorOffset should be 0", 0, selection.anchorOffset);
	assertNull("focusNode should be undefined", selection.focusNode);
	assertEquals("focusOffset should be 0", 0, selection.focusOffset);
	
	IP.select();
	assertEquals("anchorNode should be 'target2'", node, selection.anchorNode);
	assertEquals("anchorOffset should be "+offset, offset, selection.anchorOffset);
	assertEquals("focusNode should be 'target2'", node, selection.focusNode);
	assertEquals("focusOffset should be "+offset, offset, selection.focusOffset);
}

/**
 *
 */
function testExtend() {
	var selection = window.getSelection();
	resetSelection();
	var IP = selection.createInsertionPoint();
	
	for(var i=0; i < 20; i++) IP.next();
	IP.extend();
	assertEquals("anchorNode should be 'target2'", document.getElementById("target2").firstChild, selection.anchorNode);
	assertEquals("anchorOffset should be 0", 0, selection.anchorOffset);
	assertEquals("focusNode should be the IP node", IP.getNode(), selection.focusNode);
	assertEquals("focusOffset should be the IP offset", IP.getOffset(), selection.focusOffset);
	
}

/**
 *
 */
function testSeek() {
	var selection = window.getSelection();
	resetSelection();
	var IP = selection.createInsertionPoint();
	
	mozile.setCurrentEditor(document.getElementById("target"));
	IP._seekTextNode("previous");
	assertEquals("The previous text node should be 'target[1]'", document.getElementById("target").firstChild, IP.getNode());
	IP._seekTextNode("next");
	assertEquals("The next text node should be 'target2'", document.getElementById("target2").firstChild, IP.getNode());
	
	var i;
	for(i=0; i < 20; i++) IP.next();
	assertEquals("The IP should now be in 'target[2]'", document.getElementById("target").lastChild, IP.getNode());
	for(i=0; i < 20; i++) IP.previous();
	assertEquals("The IP should now be in 'target2'", document.getElementById("target2").firstChild, IP.getNode());

}


/**
 *
 */
function resetSelection() {
	var anchorNode = document.getElementById("target2").firstChild;
	var anchorOffset = 0;
	//var focusNode = document.getElementById("target2").firstChild;
	//var focusOffset = 5;
	var selection = window.getSelection();
	var range = document.createRange();
	
	range.setStart(anchorNode, anchorOffset);
	//range.setEnd(focusNode, focusOffset);
	selection.removeAllRanges();
	selection.addRange(range);
}