/** Mozile Command Test Script
 * @fileoverview This file contains JSUnit test functions for testing the MozileCommandList object.
 * Requires MozileCommandUtils.js, MozileComponentUtils.js
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */


var name = "DummyCommandList";
var id = "Mozile-TestCommand";
var label = "Test";
var tooltip = "Test Command";
var accelerator = "Command-T";
var accesskey = "T";
var image = "images/test.png";

var configString = name+": id="+id+", label="+label+", tooltip='"+tooltip+"', accesskey="+accesskey+", accelerator='"+accelerator+"', image='"+image+"'";


/** Test - Constructor
 * Test the constructor and basic methods.
 */

function testConstructor() {
	var component = new MozileCommandList(name);
	checkComponentBasics(component);
}


/** Test - Command
 * Create a command and make sure it's working
 */
function testCommand() {
	var component = new MozileCommandList(configString);
	checkComponentBasics(component);
	checkCommandOptions(component);
	checkOptions(component);
}


/** Test - Elements
 * Check the elements created by the command.
 */
function testElements() {
	var component = new MozileCommandList(configString);
	checkComponentBasics(component);

	checkButton(component.getButton());
	assertEquals("The type of element should equal 'menu'", "menu", component.getButton().getAttribute("type"));
	
	checkBox(component.getBox());
	checkMenu(component.getMenu());
	assertEquals("The menu and menuitem should be the same", component.getMenuitem(), component.getMenu());
}


/** Test - Commands
 * Check the getCommands, getCommand, and createCommand methods.
 */
function testCommands() {
	var component = new MozileCommandList(configString);
	
	assertNotNull("getCommands() should not be null", component.getCommands());
	assertNotUndefined("getCommands() should be defined", component.getCommands());
	
	var commandId = "testCommand";
	var commandString = "MozileCommand: id="+id;
	
	assertUndefined("getCommand(id) should return undefined", component.getCommand(id));
	
	component.createCommand(commandString);
	assertNotUndefined("getCommand(id) should now be defined", component.getCommand(id));
	assertEquals("The id of the command should equal "+id, id, component.getCommand(id).getId());

}






/** Check Box
 * Makes sure the box element attributes are properly set.
 */
function checkBox(element) {
	assertEquals("The localName of element should be 'div'", "div", element.localName);
	assertEquals("The id of element should equal id-Box", id+"-Box", element.getAttribute("id"));
	assertEquals("The class of element should equal 'mozileBox'", "mozileBox", element.getAttribute("class"));
	assertEquals("The label of element should equal "+label, label, element.getAttribute("label"));
	assertEquals("The tooltiptext of element should equal "+tooltip, tooltip, element.getAttribute("tooltiptext"));
}


/** Check Menu
 * Makes sure the menuitem element attributes are properly set.
 */
function checkMenu(element) {
	assertEquals("The localName of element should be 'menu'", "menu", element.localName);
	assertEquals("The id of element should equal id-Menu", id+"-Menu", element.getAttribute("id"));
	assertEquals("The class of element should equal 'mozileMenu'", "mozileMenu", element.getAttribute("class"));
	assertEquals("The label of element should equal "+label, label, element.getAttribute("label"));
	assertEquals("The tooltiptext of element should equal "+tooltip, tooltip, element.getAttribute("tooltiptext"));
	assertEquals("The accesskey of element should equal "+accesskey, accesskey, element.getAttribute("accesskey"));
}
