/** Mozile Selection Test Script
 * @fileoverview This file contains JSUnit test functions for testing Mozile's addtions to the native Selection object.
 * 
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */

/**
 * Tests the getXPath method for three kinds of nodes.
 */
function testXPath() {
		// Element
	checkXPath(document.getElementById("target"));
		// Attribute
	checkXPath(document.getElementById("target").attributes[0]);
		// Text Node
	checkXPath(document.getElementById("target").lastChild);
}


/**
 * Tests the getXPath method for three kinds of nodes.
 */
function testBlock() {
	assertTrue("'target' is a block.", document.getElementById("target").isBlock());
	assertEquals("'target' is the parentBlock of 'target2'.", document.getElementById("target"), document.getElementById("target2").getParentBlock());
	assertTrue("'target' an ancestor of 'target2'.", document.getElementById("target").isAncestorOf(document.getElementById("target2")));
}

function testInsert() {
	var element = document.createElementNS(XHTMLNS, "span");
	document.getElementById("target").parentNode.insertAfter(element, document.getElementById("target"));
	assertEquals("'target's next sibling should be the element.", element, document.getElementById("target").nextSibling);
}


/**
 * Checks to see if an 
 * @param {Node} The node to check.
 */
function checkXPath(node) {
	//alert(node.getXPath());
	assertNotNull("getXPath should not be null.", node.getXPath());
	assertNotUndefined("getXPath should be defined.", node.getXPath());
	assertEquals("getXPath should be a string.", "string", typeof(node.getXPath()));
	
	var result = executeXPath(node.getXPath());
	assertEquals("There should be exactly one result.", 1, result.length);
	assertEquals("The result should match the node.", node, result[0]);
}


