/** Mozile Selection Test Script
 * @fileoverview This file contains JSUnit test functions for testing Mozile's addtions to the native Selection object.
 * 
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */


/**
 * Tests the deleteContent method.
 */
function testDelete() {
	var node = document.getElementById("target2").firstChild;
	var selection = window.getSelection();
	var range = document.createRange();
	range.setStart(node, 1);
	range.setEnd(node, 9);
	selection.removeAllRanges();
	selection.addRange(range);
	
	assertEquals("The node should have content.", "JavaScript", node.textContent);
	selection.deleteContents();
	assertEquals("The node should no longer have content.", "Jt", node.textContent);
}

/**
 * Tests the store and restore methods.
 */
function testStoreRestore() {
	var selection = window.getSelection();
	
	assertNull("If there's no selection, sotre should return null", selection.store());
	
	resetSelection();
	var originalRange = selection.getRangeAt(0);
	var memento = selection.store();
	assertNotNull("store() should return a value.", memento);
	assertEquals("store() should return an object.", "object", typeof(memento));
	
	assertEquals("anchorPath should be a string", "string", typeof(memento.anchorPath));
	assertEquals("anchorOffset should be a number", "number", typeof(memento.anchorOffset));
	assertEquals("focusPath should be a string", "string", typeof(memento.focusPath));
	assertEquals("focusOffset should be a number", "number", typeof(memento.focusOffset));
	
	selection.removeAllRanges();
	assertNull("If there's no selection, sotre should return null", selection.store());

	selection.restore(memento);
	var newRange = selection.getRangeAt(0);	
	assertEquals("The starts of the ranges should be the same.", 0, newRange.compareBoundaryPoints(newRange.START_TO_START, originalRange)); 
	assertEquals("The ends of the ranges should be the same.", 0, newRange.compareBoundaryPoints(newRange.END_TO_END, originalRange));
	
		// Bad path
	memento.anchorPath = "";
	selection.restore(memento);
	var newRange = selection.getRangeAt(0);
		// Selection should not have moved.
	assertEquals("The starts of the ranges should be the same.", 0, newRange.compareBoundaryPoints(newRange.START_TO_START, originalRange)); 
	assertEquals("The ends of the ranges should be the same.", 0, newRange.compareBoundaryPoints(newRange.END_TO_END, originalRange));
	
}


/**
 *
 */
function resetSelection() {
	var node = document.getElementById("target2").firstChild;
	var offset = 0;
	var selection = window.getSelection();
	var range = document.createRange();
	
	range.setStart(node, offset);
	selection.removeAllRanges();
	selection.addRange(range);
}