/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.0 (the "NPL"); you may not use this file except in
 * compliance with the NPL.  You may obtain a copy of the NPL at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the NPL is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the NPL
 * for the specific language governing rights and limitations under the
 * NPL.
 *
 * The Initial Developer of this code under the NPL is Netscape
 * Communications Corporation.  Portions created by Netscape are
 * Copyright (C) 1998 Netscape Communications Corporation.  All Rights
 * Reserved.
 */

#include "nsITSURI.h"
#include "nsNetUtil.h"
#include "nsIIOService.h"
#include "nsFileSpec.h"
#include "nsCRT.h"
#include "nsIComponentManager.h"
#include "nsIServiceManager.h"
#include "nsReadableUtils.h"
#include "nsURLHelper.h"

////////////////////////////////////////////////////////////////////////////////
 
nsITSURI::nsITSURI()
{
}
 
nsITSURI::~nsITSURI()
{
}

NS_IMPL_THREADSAFE_ISUPPORTS3(nsITSURI, nsIITSURI, nsIURI, nsISerializable)

nsresult
nsITSURI::Init(const char *charsetHint)
{
    mCharsetHint = charsetHint;
    return NS_OK;
}

#define NS_ITS_SCHEME           NS_LITERAL_CSTRING("ms-its:")
#define NS_ITS_DELIMITER        NS_LITERAL_CSTRING("::")

// NS_ITS_SCHEME + <fileName> + NS_ITS_DELIMITER + <entryName>

nsresult
nsITSURI::FormatSpec(nsACString &entryName, nsACString &result)
{
    nsCAutoString fileSpec;
    nsresult rv = mITSFile->GetSpec(fileSpec);
    if (NS_FAILED(rv)) return rv;

    result = NS_ITS_SCHEME + fileSpec + NS_ITS_DELIMITER + entryName;
    return NS_OK;
}

////////////////////////////////////////////////////////////////////////////////
// nsISerializable methods:

NS_IMETHODIMP
nsITSURI::Read(nsIObjectInputStream* aStream)
{
    //NS_ASSERTION(0, "nsITSURI::Read");
    NS_NOTREACHED("nsITSURI::Read");
    return NS_ERROR_NOT_IMPLEMENTED;
}

NS_IMETHODIMP
nsITSURI::Write(nsIObjectOutputStream* aStream)
{
    //NS_ASSERTION(0, "nsITSURI::Write");
    NS_NOTREACHED("nsITSURI::Write");
    return NS_ERROR_NOT_IMPLEMENTED;
}

////////////////////////////////////////////////////////////////////////////////
// nsIURI methods:

NS_IMETHODIMP
nsITSURI::GetSpec(nsACString &aSpec)
{
    //NS_ASSERTION(0, "nsITSURI::GetSpec");
    nsresult rv = FormatSpec(mITSEntry, aSpec);
    /*
    nsACString::const_iterator iter;
    char buffer[80];
    sprintf(buffer,"GetSpec %d ",aSpec.Length());
    for(int i=0;i<aSpec.Length();i++) sprintf(buffer+strlen(buffer),"%c",*aSpec.BeginReading(iter).advance(i));
    //NS_ASSERTION(0, buffer);
    */
    return rv;
}

NS_IMETHODIMP
nsITSURI::SetSpec(const nsACString &aSpec)
{
    //NS_ASSERTION(0, "nsITSURI::SetSpec");
    nsresult rv;
    nsCOMPtr<nsIIOService> ioServ(do_GetIOService(&rv));
    if (NS_FAILED(rv)) return rv;

    nsCAutoString scheme;
    rv = net_ExtractURLScheme(aSpec, nsnull, nsnull, &scheme);
    if (NS_FAILED(rv)) return rv;

    if (stricmp("ms-its", scheme.get()) != 0)
        return NS_ERROR_MALFORMED_URI;

    nsACString::const_iterator begin, end, delim_begin, delim_end;
    aSpec.BeginReading(begin);
    aSpec.EndReading(end);

    delim_begin = begin;
    delim_end = end;

    if (!RFindInReadable(NS_ITS_DELIMITER, delim_begin, delim_end))
        return NS_ERROR_MALFORMED_URI;

    begin.advance(7);
    
    nsCAutoString name;
    name=Substring(begin, delim_begin);
/*
    nsACString::const_iterator iter;
    char buffer[80];
    buffer[0]=0; for(int i=7;i<aSpec.Length();i++) sprintf(buffer+strlen(buffer),"%c",*aSpec.BeginReading(iter).advance(i));
    printf("nsITSURI::SetSpec fileName=%s\n",buffer);
*/

    nsCAutoString scheme1;
    rv = net_ExtractURLScheme(name, nsnull, nsnull, &scheme1);
    if (NS_FAILED(rv)) name=NS_LITERAL_CSTRING("file:C:///Windows/Help/")+name;
    printf("nsITSURI::SetSpec name='%s'\n",name.get());
    
    rv = ioServ->NewURI(name, mCharsetHint.get(), nsnull, getter_AddRefs(mITSFile));
    if (NS_FAILED(rv)) return rv;

    mITSEntry=Substring(delim_end, end);
    /*
    rv = net_ResolveRelativePath(Substring(delim_end, end),
                                           NS_LITERAL_CSTRING(""),
                                           mITSEntry);
    */
    //NS_ASSERTION(0, "nsITSURI::SetSpec OK");
    return rv;
}

NS_IMETHODIMP
nsITSURI::GetPrePath(nsACString &prePath)
{
    //NS_ASSERTION(0, "nsITSURI::GetPrePath");
    prePath = "ms-its:";
    return NS_OK;
}

NS_IMETHODIMP
nsITSURI::GetScheme(nsACString &aScheme)
{
    //NS_ASSERTION(0, "nsITSURI::GetScheme");
    aScheme = "ms-its";
    return NS_OK;
}

NS_IMETHODIMP
nsITSURI::SetScheme(const nsACString &aScheme)
{
    //NS_ASSERTION(0, "nsITSURI::SetScheme");
    // doesn't make sense to set the scheme of a ms-its: URL
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
nsITSURI::GetUserPass(nsACString &aUserPass)
{
    //NS_ASSERTION(0, "nsITSURI::GetUserPass");
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
nsITSURI::SetUserPass(const nsACString &aUserPass)
{
    //NS_ASSERTION(0, "nsITSURI::SetUserPass");
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
nsITSURI::GetUsername(nsACString &aUsername)
{
    //NS_ASSERTION(0, "nsITSURI::GetUsername");
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
nsITSURI::SetUsername(const nsACString &aUsername)
{
    //NS_ASSERTION(0, "nsITSURI::SetUsername");
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
nsITSURI::GetPassword(nsACString &aPassword)
{
    //NS_ASSERTION(0, "nsITSURI::GetPassword");
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
nsITSURI::SetPassword(const nsACString &aPassword)
{
    //NS_ASSERTION(0, "nsITSURI::SetPassword");
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
nsITSURI::GetHostPort(nsACString &aHostPort)
{
    //NS_ASSERTION(0, "nsITSURI::GetHostPort");
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
nsITSURI::SetHostPort(const nsACString &aHostPort)
{
    //NS_ASSERTION(0, "nsITSURI::SetHostPort");
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
nsITSURI::GetHost(nsACString &aHost)
{
    //NS_ASSERTION(0, "nsITSURI::GetHost");
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
nsITSURI::SetHost(const nsACString &aHost)
{
    //NS_ASSERTION(0, "nsITSURI::SetHost");
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
nsITSURI::GetPort(PRInt32 *aPort)
{
    //NS_ASSERTION(0, "nsITSURI::GetPort");
    return NS_ERROR_FAILURE;
}
 
NS_IMETHODIMP
nsITSURI::SetPort(PRInt32 aPort)
{
    //NS_ASSERTION(0, "nsITSURI::SetPort");
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
nsITSURI::GetPath(nsACString &aPath)
{
    //NS_ASSERTION(0, "nsITSURI::GetPath");
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
nsITSURI::SetPath(const nsACString &aPath)
{
    //NS_ASSERTION(0, "nsITSURI::SetPath");
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
nsITSURI::GetAsciiSpec(nsACString &aSpec)
{
    //NS_ASSERTION(0, "nsITSURI::GetAsciiSpec");
    return GetSpec(aSpec);
}

NS_IMETHODIMP
nsITSURI::GetAsciiHost(nsACString &aHost)
{
    //NS_ASSERTION(0, "nsITSURI::GetAsciiHost");
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
nsITSURI::GetOriginCharset(nsACString &aOriginCharset)
{
    //NS_ASSERTION(0, "nsITSURI::GetOriginCharset");
    aOriginCharset.Truncate();
    return NS_OK;
}

NS_IMETHODIMP
nsITSURI::Equals(nsIURI *other, PRBool *result)
{
    //NS_ASSERTION(0, "nsITSURI::Equals");
    nsresult rv;
    *result = PR_FALSE;

    if (other == nsnull)
        return NS_OK;	// not equal

    nsCOMPtr<nsIITSURI> otherITS(do_QueryInterface(other, &rv));
    if (NS_FAILED(rv))
        return NS_OK;   // not equal

    nsCOMPtr<nsIURI> otherITSFile;
    rv = otherITS->GetITSFile(getter_AddRefs(otherITSFile));
    if (NS_FAILED(rv)) return rv;

    PRBool equal;
    rv = mITSFile->Equals(otherITSFile, &equal);
    if (NS_FAILED(rv)) return rv;
    if (!equal)
        return NS_OK;   // not equal

    *result = PR_TRUE;
    return NS_OK;
}

NS_IMETHODIMP
nsITSURI::SchemeIs(const char *i_Scheme, PRBool *o_Equals)
{
    //NS_ASSERTION(0, "nsITSURI::SchemeIs");
    NS_ENSURE_ARG_POINTER(o_Equals);
    if (!i_Scheme) return NS_ERROR_INVALID_ARG;

    if (*i_Scheme == 'm' || *i_Scheme == 'M') {
        *o_Equals = PL_strcasecmp("ms-its", i_Scheme) ? PR_FALSE : PR_TRUE;
    } else {
        *o_Equals = PR_FALSE;
    }
    return NS_OK;
}

NS_IMETHODIMP
nsITSURI::Clone(nsIURI **result)
{
    //NS_ASSERTION(0, "nsITSURI::Clone");
    nsresult rv;

    nsCOMPtr<nsIURI> newITSFile;
    rv = mITSFile->Clone(getter_AddRefs(newITSFile));
    if (NS_FAILED(rv)) return rv;

    nsITSURI* uri = new nsITSURI();
    if (uri == nsnull)
        return NS_ERROR_OUT_OF_MEMORY;

    NS_ADDREF(uri);
    uri->mITSFile = newITSFile;
    uri->mITSEntry = mITSEntry;
    *result = uri;

    return NS_OK;
}

NS_IMETHODIMP
nsITSURI::Resolve(const nsACString &relativePath, nsACString &result)
{
    //NS_ASSERTION(0, "nsITSURI::Resolve");
    /*
    nsACString::const_iterator iter;
    char buffer[160];
    sprintf(buffer,"nsITSURI::Resolve %d ",relativePath.Length());
    for(int i=0;i<relativePath.Length();i++) sprintf(buffer+strlen(buffer),"%c",*relativePath.BeginReading(iter).advance(i));
    NS_ASSERTION(0, buffer);
    */
    
    nsresult rv;

    nsCAutoString scheme;
    rv = net_ExtractURLScheme(relativePath, nsnull, nsnull, &scheme);
    if (NS_SUCCEEDED(rv)) {
        // then aSpec is absolute
        result = relativePath;
        return NS_OK;
    }

    nsCAutoString path(mITSEntry);
    PRInt32 pos = path.RFind("/");
    if (pos >= 0)
        path.Truncate(pos + 1);
    else
        path = "";

    nsACString::const_iterator iter;
    char buffer[160];
    sprintf(buffer,"nsITSURI::Resolve1 %s",path.get());
    for(int i=0;i<relativePath.Length();i++) sprintf(buffer+strlen(buffer),"%c",*relativePath.BeginReading(iter).advance(i));
	    sprintf(buffer+strlen(buffer)," | ");
    printf("%s\n",buffer);
	
    nsCAutoString resolvedEntry;
    rv = net_ResolveRelativePath(relativePath, path,
                                 resolvedEntry);
    if (NS_FAILED(rv)) return rv;
    if(relativePath.Length()>0) if(relativePath.Last()=='/') resolvedEntry+=NS_LITERAL_CSTRING("/");

    printf("nsITSURI::Resolve2 %d %s\n",path.Length(),resolvedEntry.get());

    rv = FormatSpec(resolvedEntry, result);
    if (NS_FAILED(rv)) return rv;
    
    /*
    nsACString::const_iterator iter;
    char buffer[160];
    int i;
    sprintf(buffer,"Resolve %d ",result.Length());
    for(i=0;i<result.Length();i++) sprintf(buffer+strlen(buffer),"%c",*result.BeginReading(iter).advance(i));
    NS_ASSERTION(0, buffer);
    */
    return NS_OK;
}

//----------------------------------------------------------------------------
// nsITSURI::nsIFileURL
//----------------------------------------------------------------------------

NS_IMETHODIMP
nsITSURI::GetFile(nsIFile **result)
{
    nsCAutoString fileSpec;
    nsresult rv = mITSFile->GetSpec(fileSpec);
    if (NS_FAILED(rv)) return rv;
    return net_GetFileFromURLSpec(fileSpec, result);
}

////////////////////////////////////////////////////////////////////////////////
// nsIITSURI methods:

NS_IMETHODIMP
nsITSURI::GetITSFile(nsIURI* *itsFile)
{
    //NS_ASSERTION(0, "nsITSURI::GetITSFile");
    *itsFile = mITSFile;
    NS_ADDREF(*itsFile);
    return NS_OK;
}

NS_IMETHODIMP
nsITSURI::SetITSFile(nsIURI* itsFile)
{
    //NS_ASSERTION(0, "nsITSURI::SetITSFile");
    mITSFile = itsFile;
    return NS_OK;
}

NS_IMETHODIMP
nsITSURI::GetITSEntry(nsACString &entryPath)
{
    //NS_ASSERTION(0, "nsITSURI::GetITSFile");
    // trim off any trailing ref, query, or param
    PRInt32 pos = mITSEntry.RFindCharInSet("#?;");
    if (pos < 0)
        pos = mITSEntry.Length();
    entryPath = Substring(mITSEntry, 0, pos);
    return NS_OK;
}

NS_IMETHODIMP
nsITSURI::SetITSEntry(const nsACString &entryName)
{
    //NS_ASSERTION(0, "nsITSURI::SetITSEntry");
    mITSEntry.Truncate();

    return net_ResolveRelativePath(entryName,
                                   NS_LITERAL_CSTRING(""),
                                   mITSEntry);
}

////////////////////////////////////////////////////////////////////////////////
