/***
  * The Developer of this Code is HJ van Rantwijk. Copyright
  * (C) 2001-2007 by HJ van Rantwijk.  All Rights Reserved.
  */

const MZ_TRUE = "true";
const MZ_FALSE = "false";

const BACK_BUTTON = -1;
const FORWARD_BUTTON = 1;

var gManager, gPreferences, gDialogManager, gTabbrowser, gModified;
var gBackLabel, gBackImage, gForwardLabel, gForwardImage;
var reloadInterval, helpPages, dataCollection = null;

var gElementArray = new Array();
var gElementIDs = new Array("label", "custom", "firstpage", "image", "location", "interval", 
                           "selected", "ordinal", "allowPlugins", "allowJavascript", 
                           "allowMetaRedirects", "allowSubframes", "allowImages", 
                           "interval-enabled", "allow-all", "block-all");

var defaultValues = ["about:blank", "false", "about:blank", "", "about:blank", "0", "false", "true", "true", "true", "true", "true"];
var mzRDFStore = null;
var RDF = null;

function preLaunch()
{
  gManager = window.top;
  gPreferences = window.top.gPreferences;
  gManager.selectWindowStyling(document.documentElement);
  gDialogManager = gManager.frames['mainWindowFrame'];

  gBackImage = document.getElementById('BackImage');
  gBackLabel = document.getElementById('BackLabel');
  gForwardLabel = document.getElementById('ForwardLabel');
  gForwardImage = document.getElementById('ForwardImage');

  gTabbrowser = gManager.getTabbrowser(true);

  mzRDFStore = gDialogManager.mzRDFStore;
  RDF = gDialogManager.RDF; 
}

function startup()
{
  // setResource(0);
  // initTabProperties();
  // selectDefaultButton();
  refreshPropertyData(0)
}

function onCancel(aEvent)
{
  if (gModified && gManager.gConfirmForID > 1) { // 1 = [Cancel] button
    if (gManager.getConfirmation('mzWizard', 'prefPanelConfirmCloseText'))
      storeDataCollection();
  }
  return (gManager.gConfirmForID > 2); // return true for Accel+W and Window[X]
}

function onAccept()
{
  storeDataCollection();
  return false;
}

function initTabProperties()
{
  dump("\ninitTabProperties()");
  // Is this the first run?
  if (typeof gElementIDs[0] == 'string') {
    // Yes, initialize element array (used in activateSettings)
    for (i in gElementIDs)
      gElementArray[i] = document.getElementById(gElementIDs[i]);
  }
  // Initialize textboxes, checkboxes and buttons
  // dump("\ngDialogManager.gResource: " + gDialogManager.gResource);
  dataCollection = gDialogManager.mzGetTabDataFromResource(gDialogManager.dataSource, RDF.GetResource(gDialogManager.gResource));

  if (dataCollection) {
    activateSettings(dataCollection);
    // Initialize the 'Allow All' or 'Block All' buttons
    onProperty(null);
  }
  setBackForwardButtons();
}

function activateSettings(aDataCollection)
{
  dump("\nactivateSettings()");
  gElementArray[0].value = aDataCollection[0]; // title
  gElementArray[1].checked = (aDataCollection[1] == MZ_TRUE); // custom
  gElementArray[2].value = aDataCollection[2]; // firstpage
  gElementArray[3].value = aDataCollection[3]; // image
  gElementArray[4].value = aDataCollection[4]; // location
  reloadInterval = aDataCollection[5]; // interval
  gElementArray[6].checked = (aDataCollection[6] == MZ_TRUE) ? false : true;
  // gElementArray[7].value = aDataCollection[7]; // ordinal
  gElementArray[13].checked = (reloadInterval > 0);
  gElementArray[5].disabled = (reloadInterval == 0);
  gTabbrowser.initReloadPopup(document, gElementArray[5].firstChild, null, reloadInterval);
  // Tab Properties
  for (var i = 8; i < 13; i++) {
    gElementArray[i].checked = (aDataCollection[i] == MZ_TRUE);
  }  
}

function refreshReloadState()
{
  var disabled = !gElementArray[13].checked
  gElementArray[5].disabled = disabled;

  if (disabled) {
    gElementArray[5].value = 0;
    reloadInterval = 0;
  }
}

function onProperty(aElement)
{
  var id = aElement ? aElement.getAttribute("id") : "";
  var properties = 0;
  // Count number of checked property checkboxes
  for (var i = 8; i < 13; i++) {
    if (gElementArray[i].checked)
      properties++
  }
  // Called from the 'Allow All' or 'Block All' buttons
  if (id == gElementIDs[14] || id == gElementIDs[15]) {
    properties = (id == gElementIDs[14]) ? 5 : 0;
    for (i = 8; i < 13; i++) {
      gElementArray[i].checked = properties // ? true : false;
      // Update all docShell properties
      gDialogManager.tabManager.updateTab(gElementIDs[i], properties /* ? true : false */ );
    }
  }
  // Update button state
  gElementArray[14].disabled = (properties == 5) // ? true : false;
  gElementArray[15].disabled = (properties == 0) // ? true : false;
  // Update the docShell property
  if (id.indexOf('allow') == 0) {
    gDialogManager.tabManager.updateTab(id, aElement.checked);
  }
}

function setReloadInterval(aMenuitem)
{
  reloadInterval = (aMenuitem.getAttribute('value') * 1000);
}

function setCustomLabel(setCustomLabel)
{
  gDialogManager.tabManager.updateTab('customlabel', setCustomLabel);
}

function selectDefaultButton()
{
  var tree = gDialogManager.tree;
  dump("\nselectDefaultButton() " + tree.currentIndex);
  window.focus();
  // dump("\nselectDefaultButton()");
  var acceptButton = gManager.document.documentElement.getButton('accept');
  var cancelButton = gManager.document.documentElement.getButton('cancel');
  var defaultButton = cancelButton;

  acceptButton.removeAttribute('default');
  cancelButton.removeAttribute('default');

  if (gModified)
    defaultButton = acceptButton;
  else
    acceptButton.disabled = true;
  defaultButton.setAttribute('default', 'true');
  defaultButton.focus();
}

function setBackForwardButtons()
{
  var tree = gDialogManager.tree;
  dump("\nsetBackForwardButtons()" + tree.currentIndex);

  var row = tree.currentIndex;
  dump("\nsetBackForwardButtons:tree.currentIndex: " + tree.currentIndex);
  var rows = (tree.treeBoxObject.view.rowCount-1);
  var disabled = (row > 0) ? tree.treeBoxObject.view.isContainer(row - 1) : false;

  // dump("\nBack disabled: " + disabled);
  gBackLabel.disabled = disabled;
  gBackImage.setAttribute('disabled', disabled ? 'true' : 'false');
  disabled = (row == rows) ? true : ((row + 1) < rows) ? tree.treeBoxObject.view.isContainer(row + 1) : false;
  // dump("\nForward disabled: " + disabled);
  gForwardLabel.disabled = disabled;
  gForwardImage.setAttribute('disabled', disabled ? 'true' : 'false');
  window.focus();
}

function setResource(aDirection)
{
  dump("\nsetResource("+ aDirection + ")");

  var tree = gDialogManager.tree;
  dump("\ntree.currentIndex: " + tree.currentIndex);
  tree.currentIndex = tree.currentIndex + aDirection;
  dump("\ntree.currentIndex: " + tree.currentIndex);
  gDialogManager.tabManager.selectRows('none');
  dump("\ntree.currentIndex: " + tree.currentIndex);
  tree.treeBoxObject.ensureRowIsVisible(tree.currentIndex);
  // dump("\nsetResource(3)");
  var resource = tree.builderView.getResourceAtIndex(tree.currentIndex).Value;
  // dump("\nresource: " + resource);
  document.getElementById('TabSessionID').value = resource;
  gDialogManager.gResource = resource;
}

function refreshPropertyData(aDirection)
{
  dump("\n\nrefreshPropertyData(1)");
  if ((gBackLabel.disabled && aDirection == BACK_BUTTON) || (gForwardLabel.disabled && aDirection == FORWARD_BUTTON))
    return;
  dump("\nrefreshPropertyData(2)");
  var prefString = "multizilla.session-manager.confirm.property-changes";
  var shouldSkip = gPreferences.readBoolean(prefString, false);
  var result = (gModified && shouldSkip) ? 0 : 1;

  if (gModified && !shouldSkip) {
    var dialogTitle = gDialogManager.stringBundle.getString("tsmConfirmActionTitle");
    var dialogText = gDialogManager.stringBundle.getString("tsmConfirmStorageText");
    var checkboxText = gDialogManager.stringBundle.getString("tsmKeepStorageDecisionText");
    var checkbox = {checked:true}
    var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                                  .getService(Components.interfaces.nsIPromptService);
    result = promptService.confirmEx(window, dialogTitle, dialogText,
                                     (promptService.BUTTON_POS_0 * promptService.BUTTON_TITLE_YES) + 
                                     (promptService.BUTTON_POS_1 * promptService.BUTTON_TITLE_NO),
                                     null, null, null, checkboxText, checkbox);

    gPreferences.writeBoolean(prefString, checkbox.value);
  }
  // if (result == 0) // Yes returns 0 and No, Esc and X on window returns 1
    // storeDataCollection();
  // dump("\nrefreshPropertyData(3)");
  setResource(aDirection);
  // dump("\nrefreshPropertyData(4)");
  gModified = false;
  initTabProperties();
  // dump("\nrefreshPropertyData(5)");
  // selectDefaultButton();
  // dump("\nrefreshPropertyData(6)");
  var tree = gDialogManager.tree;
  dump("\nrefreshPropertyData EXIT: " + tree.currentIndex);
}

function getDataCollection()
{
  var tree = gDialogManager.tree;
  dump("\ngetDataCollection: " + tree.currentIndex);
  // dump("\ngetDataCollection()");
  var defaultScheme = "http://";
  var aDataCollection = new Array();
  // Data Collection buildup
  aDataCollection[0] = gElementArray[0].value; // title
  aDataCollection[1] = gElementArray[1].checked ? MZ_TRUE : MZ_FALSE; // custom
  // Check for missing scheme in 'firstpage' textbox.
  if (gElementArray[2].value.indexOf(":") < 0) // Add default scheme
    gElementArray[2].value = defaultScheme + gElementArray[2].value;
  if (gElementArray[2].value == defaultScheme)
    gElementArray[2].value = defaultValues[2];
  aDataCollection[2] = gElementArray[2].value; // firstpage
  aDataCollection[3] = gElementArray[3].value; // image
  // Check for missing scheme in 'location' textbox.
  if (gElementArray[4].value.indexOf(":") < 0) // Add default scheme
    gElementArray[4].value = defaultScheme + gElementArray[4].value;
  if (gElementArray[4].value == defaultScheme)
    gElementArray[4].value = defaultValues[4];
  aDataCollection[4] = gElementArray[4].value; // location
  aDataCollection[5] = reloadInterval; // Reload interval
  aDataCollection[6] = gElementArray[6].checked ? MZ_FALSE : MZ_TRUE;
  // aDataCollection[7] = gElementArray[7].value; // ordinal
  // Tab Properties
  for (var i = 8; i < 13; i++) {
    aDataCollection[i] = gElementArray[i].checked ? MZ_TRUE : MZ_FALSE;
  }
  return aDataCollection;
}

function storeDataCollection()
{
  var MZ = "http://multizilla.mozdev.org/rdf#";
  var modifiedDataCollection = getDataCollection();
  var resource = RDF.GetResource(gDialogManager.gResource);

  try {
    for (var i = 0; i < 13; i++) {
      if (i == 7) // Skip ordinal
        continue;
      if (dataCollection[i] != modifiedDataCollection[i]) {
        var property = RDF.GetResource(MZ+gElementIDs[i]);
        var newValue = RDF.GetLiteral(modifiedDataCollection[i]);
        var currentValue = gDialogManager.dataSource.GetTarget(resource, property, true);

        if (modifiedDataCollection[i] == defaultValues[i])
          gDialogManager.dataSource.Unassert(resource, property, currentValue);
        else
          gDialogManager.mzAddOrChangeValue(gDialogManager.dataSource, resource, property, currentValue, newValue);
      }
    }
  } catch(ex) { 
    // die silently
  }
  gDialogManager.mzFlushDataSource(gDialogManager.dataSource);
  gModified = false;
}


