/*
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 * 
 * The Original Code in this file as it was released upon
 * April 1, 2001 and that is NO joke!
 * 
 * The Initial Developer of the Original Code is Henk-Johan van Rantwijk.
 * all Portions created by Henk-Johan van Rantwijk are Copyright (C) 2001
 * by Henk-Johan van Rantwijk. All Rights Reserved.
 * 
 * Contributor(s):
 *   Henk-Johan van Rantwijk <bugs4hj@netscape.net> (Original Author)
 *   David Perry <d.perry@utoronto.ca> (Close All - Keep List author)
 * 
*/

////////////////////////////////////////////////////////////////////////////////
// Javascript functions used to handle the UI for the multiZilla extension
// Focus of this file is "Close All - Keep List" dialog
// Current version : 1.0.1 (1.0.xx versions are my private Alpha releases)
// Written by : (DP) David Perry <d.perry@utoronto.ca>
////////////////////////////////////////////////////////////////////////////////

var caOK = 0; // Was window exited via OK button?

////////////////////////////////////////////////////////////////////////////////
// this function initializes dialog and populates the tree structure -
// is called from dialog's onload()
////////////////////////////////////////////////////////////////////////////////
function caWinInit()
{
  var tabList = window.arguments[ 0 ];

  for ( var i = 0; i < tabList.length; i++ ) {
    var tabName     = tabList[ i ].name;
    var tabURI      = tabList[ i ].URI;
    var tabClosable = tabList[ i ].closable;

    createCell( tabName, tabURI, i, tabClosable );
  }
}
////////////////////////////////////////////////////////////////////////////////
// this function adds a cell to the tree --
// adapted from chrome://communicator/content/pref/pref-smart_browsing.xul
////////////////////////////////////////////////////////////////////////////////
function createCell( aName, aURI, aId, aClosable )
{
  var treeKids  = document.getElementById( "caListBox" );
  var row       = document.createElement( "listitem" );
  var nameCell  = document.createElement( "listcell" );
  var URIcell   = document.createElement( "listcell" );

  nameCell.setAttribute( "label", aName );
  URIcell.setAttribute( "label", aURI );
  row.appendChild( nameCell );
  row.appendChild( URIcell );
  row.setAttribute( "id", aId );

  if ( !aClosable )
    row.setAttribute( "disabled", "true" );

  treeKids.appendChild( row );
  return;
}
////////////////////////////////////////////////////////////////////////////////
// this function performs "Deselect All" in dialog
////////////////////////////////////////////////////////////////////////////////
function caSelNone()
{
  document.getElementById( "caListBox" ).clearSelection();
}
////////////////////////////////////////////////////////////////////////////////
// this function performs "Select All" in dialog
////////////////////////////////////////////////////////////////////////////////
function caSelAll()
{
  var caList = document.getElementById( "caListBox" );

  for ( var i = 0; i < caList.getRowCount(); i++ ) {
    if ( !caList.getItemAtIndex( i ).getAttribute( "disabled" ) )
      caList.addItemToSelection( caList.getItemAtIndex( i ) );
  }
}
////////////////////////////////////////////////////////////////////////////////
// this function marshals which tabs are to be closed -
// is called from dialog's onunload()
////////////////////////////////////////////////////////////////////////////////
function caDlgClose()
{
  if ( caOK ) {
    var caList = document.getElementById( "caListBox" );
    for ( var i = 0; i < caList.selectedCount; i++ ) {
      window.arguments[ 0 ][ caList.getSelectedItem( i ).getAttribute( "id" ) ].closeMe = "true";
    }
  }
}


