/* 
   - The contents of this file are subject to the Mozilla Public
   - License Version 1.1 (the "License"); you may not use this file
   - except in compliance with the License. You may obtain a copy of
   - the License at http://www.mozilla.org/MPL/
   -
   - Software distributed under the License is distributed on an "AS
   - IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
   - implied. See the License for the specific language governing
   - rights and limitations under the License.
   -
   - The Original Code is this file as it was released on
   - March 20, 2000.
   -
   - The Initial Developer of the Original Code is Henk-Johan van Rantwijk.
   - Portions created by Henk-Johan van Rantwijk are Copyright (C) 2000
   - Henk-Johan van Rantwijk.  All Rights Reserved.
   -
   - Contributor(s):
   -  Henk-Johan van Rantwijk <bugs4hj@netscape.net> (Original Author)
   -
   - Alternatively, the contents of this file may be used under the
   - terms of the GNU General Public License Version 2 or later (the
   - "GPL"), in which case the provisions of the GPL are applicable
   - instead of those above.  If you wish to allow use of your
   - version of this file only under the terms of the GPL and not to
   - allow others to use your version of this file under the MPL,
   - indicate your decision by deleting the provisions above and
   - replace them with the notice and other provisions required by
   - the GPL.  If you do not delete the provisions above, a recipient
   - may use your version of this file under either the MPL or the
   - GPL.
   -
*/

////////////////////////////////////////////////////////////////////////////////
// Javascript functions used to handle the UI for the MultiZilla extension
// Current version : 1.1.20
// Written by : (HJ) Henk-Johan van Rantwijk <bugs4hj@netscape.net>
////////////////////////////////////////////////////////////////////////////////

// WARNING: CHANGE THIS WHEN MOVING FILES - strings localization file!
var multiviewsBundle = "chrome://multiviews/locale/multiviews.properties";

var RDF = Components.classes["@mozilla.org/rdf/rdf-service;1"]
                    .getService(Components.interfaces.nsIRDFService);
var RDFC = Components.classes["@mozilla.org/rdf/container-utils;1"]
                     .getService(Components.interfaces.nsIRDFContainerUtils);
var gdLocalStore = RDF.GetDataSource("rdf:local-store");

var mzToolbox = null;
////////////////////////////////////////////////////////////////////////////////
//  custom PrefListener for MultiZilla's GoogleBox
////////////////////////////////////////////////////////////////////////////////
const gbToolboxVisibilityPrefListener =
{
  domain: "multizilla.integrated.toolbar",
  observe: function(subject, topic, prefName)
  {
    if (topic != "nsPref:changed")
      return;

    var isVisible = pref.getBoolPref(prefName);
    mzToolbox.mzToolboxSetVisibility(isVisible);
  }
};
////////////////////////////////////////////////////////////////////////////////
//  custom PrefListener for MultiZilla
////////////////////////////////////////////////////////////////////////////////
const gTabMinWidthPrefListener =
{
  domain: "multizilla.tabs.mintabwidth",
  observe: function(subject, topic, prefName)
  {
    if (topic != "nsPref:changed")
      return;

    var tabWidth = pref.getIntPref(prefName);
    gBrowser.setTabWidthTo("minwidth", tabWidth);
  }
};
////////////////////////////////////////////////////////////////////////////////
//  custom PrefListener for MultiZilla
////////////////////////////////////////////////////////////////////////////////
const gTabWidthPrefListener =
{
  domain: "multizilla.tabs.tabwidth",
  observe: function(subject, topic, prefName)
  {
    if (topic != "nsPref:changed")
      return;

    var tabWidth = pref.getIntPref(prefName);
    gBrowser.setTabWidthTo("maxwidth", tabWidth);
  }
};
////////////////////////////////////////////////////////////////////////////////
//  custom PrefListener for MultiZilla
////////////////////////////////////////////////////////////////////////////////
const gTabLEDstatePrefListener =
{
  domain: "multizilla.tabs.status-leds",
  observe: function(subject, topic, prefName)
  {
    if (topic != "nsPref:changed")
      return;

    var tabLEDstate = pref.getBoolPref(prefName);
    gBrowser.setTabLEDstateTo(tabLEDstate);
  }
};
////////////////////////////////////////////////////////////////////////////////
//  custom PrefListener for MultiZilla
////////////////////////////////////////////////////////////////////////////////
const gTabLabelPrefListener =
{
  domain: "multizilla.tabs.title",
  observe: function(subject, topic, prefName)
  {
    if (topic != "nsPref:changed")
      return;

    var tabLabel = pref.getBoolPref(prefName);
    gBrowser.setTabLabelsTo(tabLabel);
  }
};
////////////////////////////////////////////////////////////////////////////////
//  custom PrefListener for MultiZilla
////////////////////////////////////////////////////////////////////////////////
const gTabSwitchPrefListener =
{
  domain: "multizilla.tabs.ontop",
  observe: function(subject, topic, prefName)
  {
    if (topic != "nsPref:changed")
      return;

    var topTabs = pref.getBoolPref(prefName);
    if (topTabs)
      gBrowser.activateTopTabs()
    else gBrowser.activateBottomTabs();
  }
};
////////////////////////////////////////////////////////////////////////////////
//  custom PrefListener for MultiZilla
////////////////////////////////////////////////////////////////////////////////
const gTabCanClosePrefListener =
{
  domain: "multizilla.tabs.iconclose",
  observe: function(subject, topic, prefName)
  {
    if (topic != "nsPref:changed")
      return;

    var tabCanClose = pref.getBoolPref(prefName);
    gBrowser.setTabCanClose(tabCanClose);
  }
};
////////////////////////////////////////////////////////////////////////////////
//  custom PrefListener for MultiZilla
////////////////////////////////////////////////////////////////////////////////
const gTBButtonPrefListener =
{
  domain: "multizilla.showbutton",
  observe: function(subject, topic, prefName)
  {
    if (topic != "nsPref:changed")
      return;
    var buttonName = prefName.substr(this.domain.length+1);
    var buttonId = buttonName + "-tbbutton";
    var button = document.getElementById(buttonId);

    var show = pref.getBoolPref(prefName);
    button.setAttribute("hidden", (show ? "false" : "true"));
  }
};
////////////////////////////////////////////////////////////////////////////////
// this function asks the user to confirm to quit the session
////////////////////////////////////////////////////////////////////////////////
function confirmCloseWS(aConfirm)
{
  var confirmPref = readMyPref("multizilla.confirm.quit", "int", 0);
  var closeBundle = srGetStrBundle("chrome://multiviews/locale/multiviews.properties");
  var aHeader = closeBundle.GetStringFromName("closeSession");
  var aQuestion = closeBundle.GetStringFromName("closeSessionQuestion");
  /* ::::
     1 = File Menu 'Close Window' & Ctrl-Shift-W
     2 = File Menu 'Exit' & Ctrl-Q
     4 = Click on [X] on Window
     8 = JavaScript close()
  :::: */
  if (aConfirm == 8 && document.documentElement.hasAttribute("chromehidden"))
    return true;
  if (aConfirm & 1) {
    aHeader = closeBundle.GetStringFromName("closeWindow");
    aQuestion = closeBundle.GetStringFromName("closeWindowQuestion");
  }
  if (confirmPref && (confirmPref & aConfirm) == aConfirm) {
    var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].
                        getService(Components.interfaces.nsIPromptService);

    if (promptService.confirm(window, aHeader, aQuestion)) {
      checkGroupSaving();
      return true;
    }
    else
      return false;
  }
  checkGroupSaving();
  return true;
}
////////////////////////////////////////////////////////////////////////////////
// this function adds pref listenes and puts the MT in place
////////////////////////////////////////////////////////////////////////////////
function multiZillaInit()
{
  addPrefListener(gbToolboxVisibilityPrefListener);
  addPrefListener(gTabMinWidthPrefListener);
  addPrefListener(gTabWidthPrefListener);
  addPrefListener(gTabLEDstatePrefListener);
  addPrefListener(gTabLabelPrefListener);
  addPrefListener(gTabSwitchPrefListener);
  addPrefListener(gTBButtonPrefListener);
  addPrefListener(gTabCanClosePrefListener);
  initPreferences();
}
////////////////////////////////////////////////////////////////////////////////
// this function sets ID's to the Go Menu and replaces the popup
// I know this is a dirty way to do it, but we need to ;)
////////////////////////////////////////////////////////////////////////////////
function addGoMenuIDs()
{
  var goMenu = document.getElementById("main-menubar").childNodes[3];
  goMenu.setAttribute("id", "menu_Go");
  var goMenuPopup = document.getElementById("menu_GoPopup");
  goMenu.firstChild.setAttribute("id", "menu_GoPopup");
  goMenu.replaceChild(goMenuPopup, goMenu.firstChild);

  // replace Bookmarks menu template
  var mainMenu = document.getElementById("main-menubar");
  var newBookmarkMenu = document.getElementById("NewBookmarksMenu");
  var clonedMenu = newBookmarkMenu.cloneNode(true);
  mainMenu.replaceChild(clonedMenu, mainMenu.childNodes[4]);
  clonedMenu.setAttribute("id", "BookmarksMenu");
  clonedMenu.setAttribute("hidden", "false");

  // added for the integrated toolbar
  var shouldDisplay = readMyPref("multizilla.integrated.toolbar", "bool", false);
  mzToolbox = document.getElementById("MultiZillaToolbar");
  mzToolbox.mzToolboxSetVisibility(shouldDisplay);
  // hide menu items in PT Bookmarks button
  var bmButton = document.getElementById("bookmarks-button");
  bmButton.firstChild.childNodes[3].setAttribute("hidden", "true");
  bmButton.firstChild.childNodes[4].setAttribute("hidden", "true");
}
////////////////////////////////////////////////////////////////////////////////
// this function checks if this is the first open "navigator:browser" window
////////////////////////////////////////////////////////////////////////////////
function isFirstWindow()
{
  var windowManager = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService();
  var windowManagerInterface = windowManager.QueryInterface(Components.interfaces.nsIWindowMediator);
  var topWindow = windowManagerInterface.getMostRecentWindow(null);
  var enumerator = windowManagerInterface.getEnumerator("navigator:browser");
  var firstWindow = enumerator.getNext().QueryInterface(Components.interfaces.nsIDOMWindowInternal);

  if (firstWindow != topWindow)
    return(false);
  return(true);
}
////////////////////////////////////////////////////////////////////////////////
// this function reads group data from localstore.rdf
////////////////////////////////////////////////////////////////////////////////
function loadTabGroup()
{
  var index = 0;
  if (!isFirstWindow())
    return(index);
  var urls = RDFC.MakeSeq(gdLocalStore, RDF.GetResource("nc:group-url")).GetElements();
  var labels = RDFC.MakeSeq(gdLocalStore, RDF.GetResource("nc:group-label")).GetElements();

  if (!urls.hasMoreElements())
    return(index);

  while (urls.hasMoreElements()) {
    var url = urls.getNext();
    var label = labels.getNext();
    if (url && label) {
      try {
        url = url.QueryInterface(Components.interfaces.nsIRDFLiteral);
        label = label.QueryInterface(Components.interfaces.nsIRDFLiteral);
        index++;
      } catch(ex) {
        continue;
      }
      if (index == 1 && useFirstPage())
        loadURI(url.Value);
      else
        getBrowser().addTab(url.Value);
      var tab = getBrowser().mTabContainer.lastChild;
      if (label.Value != "false") {
        tab.setAttribute("customLabel", "true");
        tab.setAttribute("label", label.Value);
      }
    }
  }
  return(index);
}
////////////////////////////////////////////////////////////////////////////////
// this function checks if it need to save the current group of tabs
////////////////////////////////////////////////////////////////////////////////
function checkGroupSaving()
{
  var shouldSave = readMyPref("multizilla.tabs.saveonexit", "bool", false);
  var tabCount = getBrowser().mPanelContainer.childNodes.length;

  if (!shouldSave)
    return;
  else storeGroupData();
}
////////////////////////////////////////////////////////////////////////////////
// this function checks wether or not we should use the first tab
////////////////////////////////////////////////////////////////////////////////
function useFirstPage()
{
 var uriToLoad = null;
  if ("arguments" in window && window.arguments.length >= 1 && window.arguments[0])
    uriToLoad = window.arguments[0];
  if (readMyPref("multizilla.tabs.andnotblank", "bool", true)) {
    if ((readMyPref("browser.startup.page", "int", 1) == 1 && 
        getHomePage() == "about:blank" || getHomePage() == "") || uriToLoad == "about:blank" || 
        readMyPref("browser.startup.page", "int", 0) == 3 && uriToLoad == "about:blank")
      return true;
  }
  return false;
}