/*
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License") you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 * 
 * The Original Code in this file was released April 1, 2001
 * 
 * The Initial Developer of the Original Code is Henk-Johan van Rantwijk.
 * all Portions created by Henk-Johan van Rantwijk are Copyright (C) 2001
 * by Henk-Johan van Rantwijk. All Rights Reserved.
 * 
 * Contributor(s):
 *   Henk-Johan van Rantwijk <bugs4hj@netscape.net> (Original Author)
 *   David Perry <d.perry@utoronto.ca>
 *   Neil Pryde <NeilPryde92651@netscape.net> (well I'm just HJ's typewriter)
 * 
 */

var newPrefsAdded = 0;

////////////////////////////////////////////////////////////////////////////////
// this function initializes the preferences for MultiZilla. It writes a new one
// to the pref file in case one is missing.
////////////////////////////////////////////////////////////////////////////////
function initPreferences()
{
  if (readMyPref("multizilla.prefs.checked", "bool", false))
    return; // Bail out if already checked. This will improve our startup time

  // -- prefs.js --------------------------------------------------------------------------------
  readMyPref( "multizilla.confirm.quit", "int", 3);
  readMyPref( "multizilla.forced.autocomplete", "bool", true);
  readMyPref( "multizilla.integrated.toolbar", "bool", false);
  readMyPref( "multizilla.mouse-middle-click.close", "bool", false);
  readMyPref( "multizilla.mouse-middle-click.newtab", "bool", false);
  readMyPref( "multizilla.mouse-middle-click.slavetab", "bool", false);
  readMyPref( "multizilla.newtabfor.bookmarks", "bool", false);
  readMyPref( "multizilla.newtabfor.future-1", "bool", false);
  readMyPref( "multizilla.newtabfor.groupfolders", "bool", false);
  readMyPref( "multizilla.newtabfor.locationbar", "bool", false);
  readMyPref( "multizilla.newtabfor.personal-toolbar", "bool", false);
  readMyPref( "multizilla.newtabfor.windowopen", "bool", true);
  readMyPref( "multizilla.preferred.location", "string", "http://multizilla.mozdev.org/index.html");
  readMyPref( "multizilla.preferred.fornewtabs", "bool", false);
  readMyPref( "multizilla.prevent.double", "bool", true);
  readMyPref( "multizilla.refspoof.spoofing", "int", 1)
  readMyPref( "multizilla.refspoof.spoofurl", "url", "http://ref.spoof.org/refspoof.cgi");
  readMyPref( "multizilla.tabs.andnotblank", "bool", true)
  readMyPref( "multizilla.tabs.andnotblank", "bool", true)
  readMyPref( "multizilla.tabs.confirm-close", "bool", true);
  readMyPref( "multizilla.tabs.status-leds", "bool", true);
  readMyPref( "multizilla.tabs.tabwidth", "int", 150);
  readMyPref( "multizilla.tabs.title", "bool", true);
  readMyPref( "multizilla.tabs.ontop", "bool", true);
  readMyPref( "multizilla.tabs.saveonexit", "bool", true);
  readMyPref( "multizilla.tabs.startgroup", "bool", true);
  readMyPref( "multizilla.tabs.iconclose", "bool", true);
  readMyPref( "multizilla.tabs.groupmark", "string", "");

  readMyPref( "multizilla.showbutton.closeAll", "bool", true);
  readMyPref( "multizilla.showbutton.closeDlg", "bool", true);
  readMyPref( "multizilla.showbutton.closeOther", "bool", true);
  readMyPref( "multizilla.showbutton.closeThis", "bool", true);
  readMyPref( "multizilla.showbutton.inspector", "bool", true);
  readMyPref( "multizilla.showbutton.jsconsole", "bool", true);
  readMyPref( "multizilla.showbutton.newtab", "bool", true);
  readMyPref( "multizilla.showbutton.quickprefmenu", "bool", true);
  readMyPref( "multizilla.showbutton.tablist", "bool", true);
  readMyPref( "multizilla.showbutton.tabpos", "bool", true);
  readMyPref( "multizilla.showbutton.tabstrip", "bool", true);
  readMyPref( "multizilla.showbutton.update", "bool", true);

  var mPrefChecked = (newPrefsAdded == 0);
  writePref( "bool", "multizilla.prefs.checked", mPrefChecked);
}
////////////////////////////////////////////////////////////////////////////////
// this function returns true, false or the value for the given pref setting
////////////////////////////////////////////////////////////////////////////////
function readMyPref( prefIdentifier, prefType, defaultSetup )
{
  var prefValue;
  var mvPreference = Components.classes[ "@mozilla.org/preferences;1" ]
                               .getService( Components.interfaces.nsIPrefBranch );

  switch( prefType )
    {
      case "bool": 
        {
          try {
            prefValue = mvPreference.getBoolPref( prefIdentifier ); 
          }
          catch( ex ) {
            writePref( prefType, prefIdentifier, defaultSetup );
            newPrefsAdded++;
            return ( defaultSetup );
          }
          if ( prefValue || !prefValue ) 
            return ( prefValue );
          else return ( defaultSetup );
          break;
        }
      case "int":
        {
          try {
            prefValue = mvPreference.getIntPref( prefIdentifier );
          }
          catch( ex ) {
            writePref( prefType, prefIdentifier, defaultSetup );
            newPrefsAdded++;
            return ( defaultSetup );
          }
          return ( prefValue );
          break;
        }
      case "string":
        {
          try {
            prefValue = mvPreference.getComplexValue( prefIdentifier,
                                     Components.interfaces.nsISupportsWString );
          }
          catch( ex ) {
            writePref( prefType, prefIdentifier, defaultSetup );
            newPrefsAdded++;
            return ( defaultSetup );
          }
          return prefValue.data.length ? prefValue.data : defaultSetup;
        }
      case "char":
        {
          try {
            prefValue = mvPreference.getCharPref( prefIdentifier );
          }
          catch( ex ) {
            writePref( prefType, prefIdentifier, defaultSetup );
            newPrefsAdded++;
            return ( defaultSetup );
          }
	        break;
        }
      case "url":
        {
          try {
            prefValue = mvPreference.getComplexValue( prefIdentifier,
                                     Components.interfaces.nsIPrefLocalizedString );
          }
          catch( ex ) {
            writePref( prefType, prefIdentifier, defaultSetup );
            newPrefsAdded++;
            return ( defaultSetup );
          }
          return prefValue.data.length ? prefValue.data : defaultSetup;
        }
      default:
        {
          dump( 'readMyPref(): Unsupported pref type "'+prefType+'" used\n' );
        }
    }
  return ( prefValue );
}
////////////////////////////////////////////////////////////////////////////////
// this function write the given preference type, 
////////////////////////////////////////////////////////////////////////////////
function writePref( prefType, prefString, prefValue )
{
  var mvPreference = Components.classes[ "@mozilla.org/preferences;1" ]
                     .getService( Components.interfaces.nsIPrefBranch );

  try {
    switch ( prefType ) {
      case "bool":
        {
          mvPreference.setBoolPref( prefString, prefValue );
          break;
        }
      case "int":
        {
          mvPreference.setIntPref( prefString, prefValue );
          break;
        }
      case "string":
        {
          var str = Components.classes[ "@mozilla.org/supports-wstring;1" ] 
                                       .createInstance(Components.interfaces.nsISupportsWString);
          str.data = prefValue;
          mvPreference.setComplexValue( prefString, Components.interfaces.nsISupportsWString, str );
          break;
        }
      case "url":
        {
          mvPreference.setComplexValue( prefIdentifier, Components.interfaces.nsIPrefLocalizedString, 
                                        prefValue );
          break;
        }
      case "char":
        {
          mvPreference.setCharPref( prefString, prefValue );
          break;
        }
      default:
        {
          dump( 'writePref(): Unsupported pref type "'+prefType+'" used\n' );
        }
    }
  }
  catch ( ex ) { // die silently 
  }
}
////////////////////////////////////////////////////////////////////////////////
// this function adds a small string to the useragent to identify MultiZilla
////////////////////////////////////////////////////////////////////////////////
function setIdentifier()
{
  var identifier = readMyPref("general.useragent.misc", "string", "mz:" );
  var mVersion = getBrowser().mVersion;

  if ( identifier.search( "mz:" ) == -1 )
    writePref( "string", "general.useragent.misc", identifier + "; " + mVersion, true );
}
////////////////////////////////////////////////////////////////////////////////
// this function adds a small string to the useragent to identify MultiZilla
////////////////////////////////////////////////////////////////////////////////
function removeIdentifier()
{
  var identifier = readMyPref("general.useragent.misc", "string", "" );
 
	if ( identifier.search( "mz:" ) != -1 ) {
    var startPos = identifier.search( "rv:" )
    identifier = identifier.substr( startPos, startPos + identifier.indexOf( ";" ) );
    writePref( "string", "general.useragent.misc", identifier, true );
  }
}

