/* 
   
 */

initInstall("needlesearch", "/mozdev/needlesearch", "3.0");
logComment("NeedleSearch Install initialized Version number: "+"3.0")

var installType = 'unknown'

//Test if user doesn't have an old install of NeedleSearch
f = getFolder("Chrome", "needlesearch/content/NeedleSearchOverlay.xul")
if (File.isFile(f) == true) {
	alert('You seem to have a version of NeedleSearch earlier than 3.0 installed.\n\nPlease reinstall your browser before you install the new version of NeedleSearch.')
	logComment("An old version of NeedleSearch was detected. Installation is cancelled.")
	cancelInstall()

} else {
	
	//Test if user has already installed NeedleSearch in program dir
	f = getFolder("Chrome", "needlesearch.jar")
	if (File.isFile(f) == true) {
		logComment("NeedleSearch was already installed in chrome dir")
		installType = "system"
	}
	
	//Test if user has already installed NeedleSearch in user dir
	f = getFolder("Current user", "chrome/needlesearch/needlesearch.jar")
	if (File.isFile(f) == true) {
		logComment("NeedleSearch was already installed in user dir")
		installType = "userProfile"
	}
	
	if (installType == 'unknown') {
		if (confirm("Do you wish to install NeedleSearch to your profile ?\n\n"+
	            "Click OK to install in your profile.\n\n"+
	            "Click Cancel to install it globally.")) {
			installType = "userProfile"
			logComment("User chose to do a install of type: " + installType)
		} else {
			installType = "system"
			logComment("User chose to do a install of type: " + installType)
		}
	}
	
	var chromeTarget = getFolder("Chrome", "");
	var chromeContFlag = CONTENT|DELAYED_CHROME ;
	var chromeLocFlag = LOCALE|DELAYED_CHROME ;
	
	var userTarget = getFolder("Current user", "chrome/needlesearch") ;
	var userContFlag = CONTENT|PROFILE_CHROME ;
	var userLocFlag = LOCALE|PROFILE_CHROME ;
	

	//NeedleSearchBookmarks should always be in the profile dir
	setPackageFolder(userTarget);
	err = addFile("chrome/NeedleSearchBookmarks.rdf");
	logComment("Added NeedleSearchBookmarks in the userTarget at: " + userTarget)
	
	if(installType == "system") {
		var registerContFlag = chromeContFlag ;
		var registerLocFlag = chromeLocFlag ;
		var registerTarget = chromeTarget;
		
		//If installType is system then put the Bookmarks in the template profile as well
		var defaultsTarget = getFolder("Program", "defaults/profile/US/chrome/needlesearch") ;
		setPackageFolder(defaultsTarget);
		err = addFile("chrome/NeedleSearchBookmarks.rdf");
		logComment("Added NeedleSearchBookmarks in the default profile at: " + defaultsTarget)
		
	}
	
	if(installType == "userProfile") {
		var registerContFlag = userContFlag ;
		var registerLocFlag = userLocFlag ;
		var registerTarget = userTarget ;
	}
	
	if (verifyDiskSpace(registerTarget, 140)) {
		setPackageFolder(registerTarget);
		err = addFile("chrome/needlesearch.jar");
		logComment("NeedleSearch package added succesfully")
				
		if ( err == SUCCESS ) {
			registerChrome(registerContFlag, getFolder(registerTarget, "needlesearch.jar"), "content/needlesearch/"); 
			registerChrome(registerLocFlag, getFolder(registerTarget, "needlesearch.jar"), "locale/en-US/needlesearch/");
	        registerChrome(registerLocFlag, getFolder(registerTarget, "needlesearch.jar"), "locale/de-AT/needlesearch/");
	        registerChrome(registerLocFlag, getFolder(registerTarget, "needlesearch.jar"), "locale/es-AR/needlesearch/");
	        registerChrome(registerLocFlag, getFolder(registerTarget, "needlesearch.jar"), "locale/fr/needlesearch/");
	        registerChrome(registerLocFlag, getFolder(registerTarget, "needlesearch.jar"), "locale/fi/needlesearch/");
	        registerChrome(registerLocFlag, getFolder(registerTarget, "needlesearch.jar"), "locale/nl/needlesearch/");
	        registerChrome(registerLocFlag, getFolder(registerTarget, "needlesearch.jar"), "locale/da/needlesearch/");
	        registerChrome(registerLocFlag, getFolder(registerTarget, "needlesearch.jar"), "locale/cy-GB/needlesearch/");
	        registerChrome(registerLocFlag, getFolder(registerTarget, "needlesearch.jar"), "locale/it/needlesearch/");
	        registerChrome(registerLocFlag, getFolder(registerTarget, "needlesearch.jar"), "locale/ru/needlesearch/");
	        registerChrome(registerLocFlag, getFolder(registerTarget, "needlesearch.jar"), "locale/zh-CN/needlesearch/");
	        registerChrome(registerLocFlag, getFolder(registerTarget, "needlesearch.jar"), "locale/se/needlesearch/");
	
			//Perform the install
			err = performInstall();
			
		  if ( err == SUCCESS || err == REBOOT_NEEDED ) {
		    alert("The NeedleSearch Toolbar has been installed.\nPlease restart your browser to continue.");
		    logComment("NeedleSearch Toolbar successfully installed")
		  }
		  else { 
		    alert("performInstall() bailed\n\nErrornumber: " + err);
		    logComment("NeedleSearch Toolbar couldn't be installed.\n\nErrornumber: " + err)
		  }
		} 
		else { 
		  alert("Creating the directory: needlesearch failed. Are you logged in as root?\nLinux/Unix user: make sure that all files in the directory chrome/needlesearch/ have write permissions");
		  logComment("NeedleSearch directory couldn't created in the Chrome directory.")
		}
		
	} else {
		cancelInstall()
	}
}


function verifyDiskSpace(dirPath, spaceRequired)
{
   var spaceAvailable;
   // Get the available disk space on the given path
   spaceAvailable = fileGetDiskSpaceAvailable(dirPath);

   // Convert the available disk space into kilobytes
   spaceAvailable = parseInt(spaceAvailable / 1024);
   // do the verification
   if(spaceAvailable < spaceRequired)
   {
      logComment("Insufficient disk space: " + dirPath);
      logComment("  required : " + spaceRequired + " K");
      logComment("  available: " + spaceAvailable + " K");
      return(false);
   }
   return(true);
}