/***** BEGIN LICENSE BLOCK *****
   - Version: MPL 1.1/GPL 2.0/LGPL 2.1
   -
   - The contents of this file are subject to the Mozilla Public License Version
   - 1.1 (the "License"); you may not use this file except in compliance with
   - the License. You may obtain a copy of the License at
   - http://www.mozilla.org/MPL/
   -
   - Software distributed under the License is distributed on an "AS IS" basis,
   - WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
   - for the specific language governing rights and limitations under the
   - License.
   -
   - The Initial Developer of the Original Code is Eelco van Kuik.
   -
   - Contributor(s):
   - Several developers
   -
   - Alternatively, the contents of this file may be used under the terms of
   - either the GNU General Public License Version 2 or later (the "GPL"), or
   - the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
   - in which case the provisions of the GPL or the LGPL are applicable instead
   - of those above. If you wish to allow use of your version of this file only
   - under the terms of either the GPL or the LGPL, and not to allow others to
   - use your version of this file under the terms of the MPL, indicate your
   - decision by deleting the provisions above and replace them with the notice
   - and other provisions required by the LGPL or the GPL. If you do not delete
   - the provisions above, a recipient may use your version of this file under
   - the terms of any one of the MPL, the GPL or the LGPL.
   -
   - ***** END LICENSE BLOCK *****/


//Load libraries
const Include=new Components.Constructor('@mozilla.org/moz/jssubscript-loader;1','mozIJSSubScriptLoader');
const gInc = new Include();
gInc.loadSubScript("chrome://needlesearch/content/jslib/nsPrefs.js");

var settings = {
	
	prefs : new Array(['contextTarget','_blank'], ['multiFieldSplitter', ';']),
	
	//Initialize preferences
	init : function () {
		
		for (var i = 0; i < settings.prefs.length; i++) {
			var prefVal
			prefVal = nsPrefs.getCharPref('needlesearch.' + settings.prefs[i][0])
			
			if (prefVal.length == 0) {
				prefVal = settings.prefs[i][1]
			}
			
			document.getElementById(settings.prefs[i][0]).value = prefVal
		}
	},
	
	//Save the preferences
	save : function () {
		for (var i = 0; i < settings.prefs.length; i++) {
			var prefVal
			
			prefVal = document.getElementById(settings.prefs[i][0]).value
			nsPrefs.setCharPref('needlesearch.' + settings.prefs[i][0], prefVal)
		}
	
	},
	
	mozillaInit : function () {
		try { 
			parent.initPanel('chrome://wallet/content/settings.xul');
		} catch(err){}; 
		
		//Register the callback function
		var prefWindow = parent.hPrefWindow;
		prefWindow.registerOKCallbackFunc(settings.save);
		
		settings.init();
	},
	
	clearSearchterms : function () {
	
		//Ask for a confirmation
		if ( !confirm('Do you really want to clear the list with searchterms?')) {
			return;
		}
		
		//Now clear the list
		nsHistory.clear();
	}

}
