/****** BEGIN LICENSE BLOCK *****
   - Version: MPL 1.1/GPL 2.0/LGPL 2.1
   -
   - The contents of this file are subject to the Mozilla Public License Version
   - 1.1 (the "License"); you may not use this file except in compliance with
   - the License. You may obtain a copy of the License at
   - http://www.mozilla.org/MPL/
   -
   - Software distributed under the License is distributed on an "AS IS" basis,
   - WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
   - for the specific language governing rights and limitations under the
   - License.
   -
   - The Initial Developer of the Original Code is Eelco van Kuik.
   -
   - Contributor(s):
   - Several developers
   -
   - Alternatively, the contents of this file may be used under the terms of
   - either the GNU General Public License Version 2 or later (the "GPL"), or
   - the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
   - in which case the provisions of the GPL or the LGPL are applicable instead
   - of those above. If you wish to allow use of your version of this file only
   - under the terms of either the GPL or the LGPL, and not to allow others to
   - use your version of this file under the terms of the MPL, indicate your
   - decision by deleting the provisions above and replace them with the notice
   - and other provisions required by the LGPL or the GPL. If you do not delete
   - the provisions above, a recipient may use your version of this file under
   - the terms of any one of the MPL, the GPL or the LGPL.
   -
   - ***** END LICENSE BLOCK *****/
var NeedleSearch = {
	aRDF			: null,
	aBundle			: null,
	HighlightOn		: false,
	nsTextOnly		: null,
	el				: null,
	init			: function () {
		//Load libraries
		const Include=new Components.Constructor('@mozilla.org/moz/jssubscript-loader;1','mozIJSSubScriptLoader');
		const gInc = new Include();
		gInc.loadSubScript("chrome://needlesearch/content/jslib/nsAutoAdder.js");
		gInc.loadSubScript("chrome://needlesearch/content/jslib/nsLivehttpheaders.js");
		gInc.loadSubScript("chrome://needlesearch/content/jslib/nsFind.js");
		gInc.loadSubScript("chrome://needlesearch/content/jslib/nsHighlight.js");
		gInc.loadSubScript("chrome://needlesearch/content/jslib/nsHistory.js");
		gInc.loadSubScript("chrome://needlesearch/content/jslib/nsPrefs.js");
		gInc.loadSubScript("chrome://needlesearch/content/jslib/nsRdfds.js");
		gInc.loadSubScript("chrome://needlesearch/content/jslib/nsSearchButtons.js");
		gInc.loadSubScript("chrome://needlesearch/content/jslib/nsStrings.js");
		gInc.loadSubScript("chrome://needlesearch/content/jslib/nsVirtualForm.js");
		gInc.loadSubScript("chrome://needlesearch/content/jslib/nsRdfLocator.js");
		gInc.loadSubScript("chrome://needlesearch/content/jslib/nsSniffer.js");
		gInc.loadSubScript("chrome://needlesearch/content/jslib/nsFile.js");
		
		NeedleSearch.checkFiles()
		
		//Set Javascript properties file
		var bundle = document.getElementById('needlesearch_properties');
		NeedleSearch.aBundle = bundle;
		
		//Initialize the lists
		document.getElementById('NeedleSearchBookmarksMenuPopup').datasources = 'file:///' + nsRdfLocator.getUri(true)
		document.getElementById('NeedleSearchContentAreaContextMenu').datasources = 'file:///' + nsRdfLocator.getUri(true)
		nsHistory.init()
						
		//Set all context items right
		NeedleSearch.setContextItem('ns-search-button')		
		NeedleSearch.setContextItem('ns-search-tab-button')
		NeedleSearch.setContextItem('ns-search-win-button')
		
		nsPrefs.syncPref('SearchInPage')
		
		NeedleSearch.setContextItem('ns-highlight-button')
		NeedleSearch.setContextItem('ns-autoadd-button')
		NeedleSearch.setContextItem('ns-editor-button')
		NeedleSearch.setContextItem('ns-homepage-button')
		
		//Set mode right for the Toolbar (text, icons or both)
		NeedleSearch.setMode();		
		
		//Add event listener for the context menu
		var popup = document.getElementById("contentAreaContextMenu");
		popup.addEventListener("popupshowing", NeedleSearch.showContextMenu, false);
		
		//Now remove the progress listener, otherwise it will be loaded every time
		//	you visit another page!
		getBrowser().removeEventListener("load", NeedleSearch.init, true);
		
		//Set default selected (for Mozilla this needs to be wih a little delay)
		setTimeout('NeedleSearch.setDefaultSelected()', 100)
		
	},
	
	/**
	 *	private setContextItem() checks or uncheckes individual context items
	 *
	 *@author Eelco van Kuik
	 */

	setContextItem : function (itemID) {
		var buttonHidden = document.getElementById(itemID).getAttribute("hidden")
		document.getElementById(itemID + '-Context').setAttribute("checked", (buttonHidden != 'true'))		
	},
	
	
	setVisibility : function (aObj) {
		var aID = aObj.getAttribute("id").replace("-Context", "")
		var aTarget = document.getElementById(aID)
		var aPrefVal = aTarget.hidden
		aTarget.setAttribute("hidden", !aPrefVal)
		
	},
	
	//Set mode right for Toolbar (text, icons or text & icons)
	setMode : function () {
		
		var aMode = document.getElementById('toolbar-menubar')
		if ( aMode == null && !nsSniffer.isNetscape() ) {
			//Mozilla code here
			var pr = nsPrefs.getIntPref(nsPrefs.TOOLBAR_MODE)
			if (pr == 2) {
				document.getElementById('needlesearch-toolbar').setAttribute("mode", "both");
			} else if (pr == 1) {
				document.getElementById('needlesearch-toolbar').setAttribute("mode", "text");
			} else {
				//default is icons only
				document.getElementById('needlesearch-toolbar').setAttribute("mode", "icons");
			}
		} else {
			//Firefox code here
			var aMode = document.getElementById('needlesearch-toolbar').getAttribute("mode");
			if (aMode.length > 0) {
				//mode already set
				return
			}
			
			aMode = document.getElementById('toolbar-menubar').getAttribute("mode");
			if (aMode.length > 0) {
				document.getElementById('needlesearch-toolbar').setAttribute("mode", aMode);
			}
		}
		
	},
	
	showContextMenu	: function (){
		var str = NeedleSearch.getSelectedText();
		aElem = document.getElementById('needlesearch-contentAreaContextMenu')
		aElem2 = document.getElementById('NeedleSearchContentAreaContextMenu')
		
		//Don't show when nothin is selected or no search engines are added to the context menu
		if (!str || aElem2.childNodes.length == 1 ) {
			aElem.setAttribute('hidden', 'true')
		} else {
			aElem.setAttribute('hidden', 'false')
		}
		
	},
	switchAutoAdd	: function () {
		
		if (!nsAutoAdder.STATUS) {
		    //nsAutoAdder.start(window._content)
		    startHeaderInfoLive()
		    nsAutoAdder.STATUS = true
			document.getElementById('ns-autoadd-button').setAttribute("label", NeedleSearch.aBundle.getString('ns.noimage_autoadd_active'));	
			document.getElementById('ns-autoadd-button').setAttribute("class", "ns-autoadd-on")
	    } else {
		    //switch it off
		    //nsAutoAdder.stop()
		    document.getElementById('ns-autoadd-button').setAttribute("label", NeedleSearch.aBundle.getString('ns.noimage_autoadd'));
			document.getElementById('ns-autoadd-button').setAttribute("class", "ns-autoadd-off")
			stopHeaderInfoLive()
			nsAutoAdder.STATUS = false
		}
	},
	/* get the information and add it to the NeedleSearch Bookmarks */
	
	finishAutoAdd	: function (getdata, postdata, encoding) {
		
		 //Get a label for the new entry, let the user fill it in.
        
		document.getElementById('ns-autoadd-button').setAttribute("label", NeedleSearch.aBundle.getString('ns.noimage_autoadd'));
		document.getElementById('ns-autoadd-button').setAttribute("class", "ns-autoadd-off")
		nsAutoAdder.STATUS = false

    	var label = getdata.replace('http://', '')
    	label = label.substring(0, label.indexOf('/'))
		
		if ( label = prompt(document.getElementById('needlesearch_properties').getString('ns.autoadd_prompt'), label) ) {
    		if (typeof(label) == 'object' || label.replace(/^\s+|\s+$/, '') == '') {
    			label = aHost
    		}
    	} else {
    		//User pressed cancel on prompt
    		return;
    	}
    	
    	/* Alternative temporary code*/
    	//alert(document.getElementById('needlesearch_properties').getString('ns.autoadd_succes') + ' ' + label)
    	
    	
		//Check which method was used
		var method
		if ( postdata.length > 0 ) {
			method = 'post'
		} else {
			method = 'get'
		}
		
		//Glue the searchstring together, check if form wasn't badly constructed
		var searchstring
		if ( getdata.indexOf('?') > 0 ) {
			//Could be encountered in bad HTML, like Google Desktop
			searchstring = getdata + '&' + postdata
			if ( searchstring.charAt( searchstring.length - 1 ) ) {
				searchstring = searchstring.substring(0, searchstring.length-1 )
			}
		} else {
			//The way it should be
			searchstring = getdata + '?' + postdata
		}
		
		//Use the rdfds lib to insert the new entry. Do it anonymously (is like sequence)
		var aUri 		=	'file:///' + nsRdfLocator.getUri(true)
		var dsource		= 	new nsRdfds.RDFDataSource(aUri)
		var aRootNode	=	dsource.getNode(nsRdfds.baseURI) ;
		var child		=	dsource.getAnonymousNode();
		child			=	aRootNode.addChild(child);
		child.addTarget(nsRdfds.aXMLPath + 'type', 'item');
		child.addTarget(nsRdfds.aXMLPath + 'label', label);
		child.addTarget(nsRdfds.aXMLPath + 'searchstring', searchstring);
		child.addTarget(nsRdfds.aXMLPath + 'method', method);
		child.addTarget(nsRdfds.aXMLPath + 'encoding', encoding);
		dsource.save();
	    dsource.refresh()
	    return true;

	},
	
	highLightInPage	: function () {
		nsHighlight.hl()
	},
	captureEvent	: function (event) {
		if (event.keyCode == 13 && event.shiftKey) {
                return NeedleSearch.searchBar('_blank')
        }

        if (event.keyCode == 13 && event.ctrlKey) {
                return NeedleSearch.searchBar('newtab')
        }

        if(event.keyCode == 13) {
                return NeedleSearch.searchBar('_top')
        }
        
        NeedleSearch.inputChanged( event.target )
	},
	inputChanged	: function (aTextfield) {
		var aArea = document.getElementById('NeedleSearchTerms')
		nsSearchButtons.clear(aArea);
		aArea.scrollByIndex ( -20 )
		if ( document.getElementById('SearchInPage-Context').getAttribute('checked') == 'true' ) {
			nsSearchButtons.create(aArea, aTextfield.value);
		}
	},
	findInPage		: function (str) {
		
		if (str == "") return false
		
		var result = nsFind.find(str)
		if (!result) {
			alert(str +' ' + document.getElementById('needlesearch_properties').getString('ns.str_not_found'))
		}
	},
	searchBar	: function (target) {
		var method, encoding, searchstring, searchterms
	    var engineList = document.getElementById('NeedleSearchBookmarksMenu')
	    
		method = engineList.selectedItem.getAttribute("method")
	    encoding = engineList.selectedItem.getAttribute("encoding")
	    searchstring = engineList.selectedItem.getAttribute("searchstring")
	    searchterms = document.getElementById('NeedleSearchSearchTerms').value
		
		nsHistory.add( searchterms )
		
		var aVF = new nsVirtualForm(searchstring, target, searchterms, method, encoding)
		if (aVF.isSuccess) {
			aVF.submit()
		} else {
			//Probably it wasn't HTML what was shown
			window._content.location = 'about:blank'
			setTimeout("aVF = new nsVirtualForm('" + searchstring + "', '" + target + "', '" + searchterms + "', '" + method + "', '"+ encoding + "'); aVF.submit()", 250)
		}
		
		
	},
	searchContext : function (theObject) {
		//This should go in pref window
		var searchstring = theObject.getAttribute("searchstring")
		var encoding = theObject.getAttribute("encoding")
		var method = theObject.getAttribute("method")
		
		var target
		try {
			target = nsPrefs.getCharPref(nsPrefs.NS_CONTEXTTARGET)
		} catch(err) {
			target = '_blank'
		}

		var searchterms = NeedleSearch.getSelectedText()
		
		//Add it on the toolbar		
		var searchtermsField = document.getElementById('NeedleSearchSearchTerms')
		searchtermsField.value = searchterms
		NeedleSearch.inputChanged(searchtermsField)
		nsHistory.add(searchterms)
		
		var aVF = new nsVirtualForm(searchstring, target, searchterms, method, encoding)
		aVF.submit()

		
	},
	getSelectedText : function () {
	   var focusedWindow = document.commandDispatcher.focusedWindow;
	   var selection = focusedWindow.getSelection();
	   selection = selection.toString()
	   selection = nsStrings.trim( selection );
	   return selection;
	
	},
	/*
	 *clearSearchterms clears the list with search terms
	 *
	 */
	clearSearchterms   : function () {
	
		if ( !confirm( document.getElementById('needlesearch_properties').getString('ns.clear_search_history')) ) {
			return;
		}
		
		//Now clear the list
		nsHistory.clear();
	
	},
	setDefaultSelected : function () {
		
		var prefVal
		var engineList = document.getElementById('NeedleSearchBookmarksMenu')
		
		//select the first option as default
		var i = 1
		engineList.selectedIndex = 1
		
		//This is stupid; why doesn't XUL accept attribute selected...?
		var aUri = 'file:///' + nsRdfLocator.getUri(true)
		var dsource		= new nsRdfds.RDFDataSource(aUri)
		var aRootNode	=	dsource.getNode(nsRdfds.baseURI) ;
		var children	=	aRootNode.getChildren()
		var child, aVal
		
		if (!children){
			//NeedleSearchBookmarks.rdf hasn't been created yet
			
		}
		
		while (children.hasMoreElements()) {
			child = children.getNext()
			aVal = child.getTarget(nsRdfds.aXMLPath + "defaultselected")
			
			if (aVal != null) {
				engineList.selectedIndex = i
				return
			}
			i++	
			
		}
		
	},
	
	//createBookmarks file
	checkFiles : function () {
		//First check NeedleSearch Bookmarks
		var aUri = nsRdfLocator.getUri(false) 
		var sample = '<?xml version="1.0"?>' + 
						'<RDF:RDF xmlns:NS2="http://www.personal-searchengines.com/rdf#"\n' + 
						'         xmlns:NC="http://home.netscape.com/NC-rdf#"\n' + 
						'         xmlns:RDF="http://www.w3.org/1999/02/22-rdf-syntax-ns#">\n' + 
						'  <RDF:Seq RDF:about="urn:needlesearch:data">\n' + 
						'    <RDF:li RDF:resource="rdf:#$nqQdv"/>\n' + 
						'	 <RDF:li RDF:resource="rdf:#$LRLJF2"/>' +
						'  </RDF:Seq>\n' + 
						'  <RDF:Description RDF:about="rdf:#$nqQdv"\n' + 
						'                   NS2:type="item"\n' + 
						'                   NS2:defaultselected="true"\n' + 
						'                   NS2:label="Google Search"\n' + 
						'                   NS2:searchstring="http://www.google.com/search?ie=UTF-8&amp;q=NeedleSearch"\n' + 
						'                   NS2:encoding="UTF-8"\n' + 
						'                   NS2:context="true"\n' + 
						'                   NS2:method="get" />\n' + 
						'  <RDF:Description RDF:about="rdf:#$LRLJF2"' +
		                '   NS2:type="item"' +
		                '   NS2:label="Add new search engines..."' +
		                '   NS2:searchstring="http://www.vankuik.com/redirect.php"' +
		                '   NS2:encoding="ISO-8859-1"' +
		                '   NS2:context="false"' +
		                '   NS2:method="get" />' +
						'</RDF:RDF>\n'
		if (!nsFile.exists(aUri)) {
			nsFile.writeFile( sample, aUri )
		}
		
		aUri = nsRdfLocator.getHistory(false) 
		sample = '<?xml version="1.0"?>' + 
						'<RDF:RDF xmlns:NS4="http://www.personal-searchengines.com/rdf#"\n' + 
						'         xmlns:NC="http://home.netscape.com/NC-rdf#"\n' + 
						'         xmlns:RDF="http://www.w3.org/1999/02/22-rdf-syntax-ns#">\n' + 
						'  <RDF:Seq RDF:about="urn:needlesearch:history">\n' + 
						'  </RDF:Seq>\n' + 
						'</RDF:RDF>\n'
		if (!nsFile.exists(aUri)) {
			nsFile.writeFile( sample, aUri )
		}
		
		return
	},
	
	//Sets all attributes
	setAttributes	: function(aSource) {
		
		var elmnts = new Array('searchstring', 'method', 'encoding')
		var aTarget = document.getElementById('NeedleSearchBookmarksMenu')
		
		for (var i = 0; i < elmnts.length; i++) {
			aTarget.setAttribute(elmnts[i], aSource.getAttribute(elmnts[i]))
		}
		
		document.getElementById('needlesearch-indicator').setAttribute("label", aSource.getAttribute('label'))
		document.getElementById('NeedleSearchBookmarksMenu').setAttribute("tooltiptext", aSource.getAttribute('label'))
	},
	
	changePref : function (aEvent) {
		var item = aEvent.target
		nsPrefs.setBoolPref(nsPrefs.NS_SEARCHINPAGE, (item.getAttribute("checked") == "true"))
		
	},
	
	openEditor : function () {
		var aLink
		if (nsSniffer.isFirefox() || nsSniffer.isNetscape() )
			aLink = 'chrome://needlesearch/content/editor.xul'
		else
			aLink = 'chrome://needlesearch/content/editor_moz.xul'
			
		window.open(aLink, 'editor', 'location=no,menubar=no,status=no,toolbar=no,alwaysRaised=yes,centerscreen=yes,dependent=yes,dialog=yes,resizable=yes')
	},
	
	initManager : function (aManager) {
		alert(aManager.document.getElementById('NC:NeedleSearchBookmarksRoot'))
	},
	
	/* Function for hiding/showing toolbar & focus textfield */
	makeFocus : function () {
		
	  
		var toolbox = document.getElementById("navigator-toolbox");
		var newStatus
		for (i = 0; i < toolbox.childNodes.length; ++i) {
			var toolbar = toolbox.childNodes[i];
		    var toolbarName = toolbar.getAttribute("toolbarname");
		    var type = toolbar.getAttribute("type");
		    if ( toolbarName  && type != "menubar" ) {
		    	if (toolbarName.substring(0,12) == 'NeedleSearch') {
		    		newStatus = (toolbar.getAttribute("collapsed") != "true")
		    		toolbar.setAttribute("collapsed", toolbar.getAttribute("collapsed") != "true" );
		    		document.persist(toolbar.id, "collapsed");
		    		
		    		if ( toolbar.getAttribute("collapsed") != "true" ) {
		    			var seaBox = document.getElementById("NeedleSearchSearchTerms");
		    			seaBox.focus()
		    		}
		    	}
		    }

		}
		
		var menuItem = document.getElementById('viewneedlesearchbar');
		// Empty the menu
		if ( menuItem ) {
			menuItem.setAttribute( "checked", newStatus != true )
		}
		
	}
}
