/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is NewsFox.
 *
 * The Initial Developer of the Original Code is
 * Ron Pruitt <wa84it@gmail.com>.
 * Portions created by the Initial Developer are Copyright (C) 2011
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the LGPL or the GPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

// code based on Wladimir Palant 
// http://adblockplus.org/blog/avoiding-naming-conflicts-in-overlays

window.addEventListener('load', function()
{
	var done = false;

	function addButtonListener()
	{
  	var nb = document.getElementById("newsfox-button");
		if (nb)
		{
			nb.addEventListener("command", nfsandbox.openNewsfox, false);
  		nb.addEventListener("click", 
				function(event)
				{
					if(event.button==1 && !done)
					{
						nfsandbox.openNewsfox(true);
						done = true;
					}
				}
				, false);
		}
	}

	function removeButtonListener()
	{
		done = false;
  	var nb = document.getElementById("newsfox-button");
		if (nb)
		{
			nb.removeEventListener("command", nfsandbox.openNewsfox, false);
  		nb.removeEventListener("click", 
				function(event)
					{if(event.button==1) nfsandbox.openNewsfox(true);}
				, false);
		}
	}

	function doRegister()
	{
		document.getElementById("run-newsfox").addEventListener("command", nfsandbox.openNewsfox, false);
		addButtonListener();
		var nsbp = document.getElementById("newsfox-status-button-popup");
  	if (nsbp)
		{
			nsbp.addEventListener("command", 
				function(event){nfsandbox.NFstatusBar.subscribe(event)}, false);
  		nsbp.addEventListener("popupshowing", 
				function(event){return nfsandbox.NFstatusBar.makeMenu(this, event)}, false);
  		nsbp.addEventListener("popuphiding", 
				function(){nfsandbox.NFstatusBar._real = false}, false);
		}
		var nt = document.getElementById("navigator-toolbox");
		if (nt) nt.addEventListener("DOMNodeInserted", addButtonListener, false);
	}

	function doUnregister()
	{
		window.removeEventListener('unload', doUnregister, false);

		document.getElementById("run-newsfox").removeEventListener("command", nfsandbox.openNewsfox, false);
		removeButtonListener();
		var nsbp = document.getElementById("newsfox-status-button-popup");
  	if (nsbp)
		{
			nsbp.removeEventListener("command", 
				function(event){nfsandbox.NFstatusBar.subscribe(event)}, false);
  		nsbp.removeEventListener("popupshowing", 
				function(event){return nfsandbox.NFstatusBar.makeMenu(this, event)}, false);
  		nsbp.removeEventListener("popuphiding", 
				function(){nfsandbox.NFstatusBar._real = false}, false);
		}
		var nt = document.getElementById("navigator-toolbox");
		if (nt) nt.removeEventListener("DOMNodeInserted", addButtonListener, false);
	}



  var nfsandbox = new Components.utils.Sandbox(window);

  // Define global variables "window" and "document" for the new namespace
  nfsandbox.window = window;
  nfsandbox.document = window.document;

  // Load scripts into the namespace
  var subscriptLoader = 
		Components.classes["@mozilla.org/moz/jssubscript-loader;1"]
		.getService(Components.interfaces.mozIJSSubScriptLoader);
  subscriptLoader.loadSubScript("chrome://newsfox/content/globalfuncs.js", nfsandbox);
  subscriptLoader.loadSubScript("chrome://newsfox/content/newsfox-overlay.js", nfsandbox);
  subscriptLoader.loadSubScript("chrome://newsfox/content/options.js", nfsandbox);

	nfsandbox.NFinitoverlay();  // need this before listeners as #newsfox-status-button-popup is not defined yet

	doRegister();
	window.addEventListener('unload', doUnregister, false);

}, false);
