#ifndef STMBOSSKEY_H_
#define STMBOSSKEY_H_

#include "IStmBossKey.h"
#include "windows.h"

#define STMBOSSKEY_CONTRACTID "@supertabmode.mozdev.org/supertabmode;1"
#define STMBOSSKEY_CLASSNAME "SuperTabMode BossKey DLL"
#define STMBOSSKEY_CID  { 0x55eeede4, 0xaba6, 0x424e, { 0xa3, 0xbe, 0xb6, 0xd6, 0x5d, 0xab, 0x52, 0x6 } }

/* Header file */
class StmBossKey : public IStmBossKey
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_ISTMBOSSKEY

  StmBossKey();

private:
    ~StmBossKey();

	static LRESULT CALLBACK FFWindowProc(
		HWND hWnd,
		UINT uMsg,
		WPARAM wParam,
		LPARAM lParam
	);

	static LRESULT CALLBACK WindowProc(      
		HWND hWnd,
		UINT uMsg,
		WPARAM wParam,
		LPARAM lParam
	);

	void StmBossKey::HideFirefoxWindows(bool aHide);
	void StmBossKey::RegisterHideKey(bool aRegister);
	void StmBossKey::RegisterRestoreKey(bool aRegister);
	void StmBossKey::ShowTrayIcon(HWND aIconHwnd, bool aShow);
	void StmBossKey::SaveTrayStr(const PRUnichar *aTrayToolTips, 
								 const PRUnichar *aParamRestore, 
								 const PRUnichar *aParamExit
								 );
	void StmBossKey::PatchFFWindows(bool aPatch);
	void StmBossKey::ResetHotKey(int aFlg, UINT aModifier, PRUint32 aKeyVK);
	void StmBossKey::DeleteFFWndList();
    int  StmBossKey::GetFFWinCount();
	void StmBossKey::GetFFWindows();
	void StmBossKey::HideFFWindows();
	void StmBossKey::CreateListenerWindow(bool aCreate);
	UINT StmBossKey::GetModifier(const char *aKeyMOD);
	void StmBossKey::GetIcon(HWND hWnd, HICON& result);
	void StmBossKey::ShowPopupMenus();

	/////////////////
	static ATOM    s_wndClass;

	NOTIFYICONDATA m_nid;

	UINT           m_hideKeyMOD;
	PRUint32       m_hideKeyVK;
	UINT           m_restoreKeyMOD;
	PRUint32       m_restoreKeyVK;

	bool           m_HIDETOSYSTRAY;
	bool           m_MINIMIZETOSYSTRAY;
	bool           m_CLOSETOSYSTRAY;

	bool           m_hideKeyRegistered;
	bool           m_restoreKeyRegistered;
	bool           m_dupRestoreKeyRegistered;

	bool           m_TrayIconAdded;

	TCHAR          m_TrayTips_Str[50];
	TCHAR          m_TrayExit_Str[50];
	TCHAR          m_TrayRestore_Str[50];

	int            HotKeyId_Hide;
	int            HotKeyId_Restore;

	HMENU          m_hPopupMenu;
	HWND           m_ListenerWindow;

	struct STMFFWNDLIST {
		HWND data;
		STMFFWNDLIST* next;
		STMFFWNDLIST* pre;
	} *ffwndhp, *ffwndtp, *ffwndcp;
	int            m_ffwndCount;
	int            m_ffwndCount_pre;

protected:

};


#endif //_MY_COMPONENT_H_
