/***********************************************************************
*                           XULMaker Settings
*                            (xmSetting.js)
************************************************************************
*
* Description:
* ============
* This script defines the global settings for the XULMaker application
* as used by the various XULMaker scripts. (particularly trace.js)
*
***********************************************************************/

const TRACE_LOADING = false;
if(TRACE_LOADING){ alert("Start loading: xmSetting.js"); }
const TRACE_INITIALIZING = false;

		const VERSION = "0.40";
		//const NAMESPACE = "xulmaker:";
		const NAMESPACE = "xm:";
		const ACTIVE_ATTRNAME = NAMESPACE + "active";

var debugMode = true;
var browserMode = true;

const XM_URL_BASE = "chrome://xulmaker/content/";
const XM_SCHEMA_URL_BASE = XM_URL_BASE;
const XM_SCHEMA_FILENAME = "xul.xsd";
const XM_SCHEMA_URL = XM_SCHEMA_URL_BASE + XM_SCHEMA_FILENAME;

//----------------------------------------------------------------------
//  setPreferences()
//----------------------------------------------------------------------
function setPreferences() {
	try {
		netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
		//netscape.security.PrivilegeManager.enablePrivilege("UniversalFileAccess");
		netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserWrite");
		//alert("Set security for Preferences. ");
	} catch (e) { alert("Could NOT set security for Preferences. " + e); }

	const PREFS_CID      = "@mozilla.org/preferences;1";
	const PREFS_I_PREF   = "nsIPref";
	const PREF_STRING    = "browser.dom.window.dump.enabled";
	try {
		var Pref        = new Components.Constructor(PREFS_CID, PREFS_I_PREF);
		var pref        = new Pref( );
		pref.SetBoolPref(PREF_STRING, true);
		alert("Preferences set."); 
	} catch(e) { alert("Preferences NOT set." + e); }
}
//======================================================================
if(TRACE_LOADING){ alert("Finished loading: xmSetting.js"); }

